---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：32-ギャラリー編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **cls_fullSearchクラスの実装詳細**：使用箇所検索の実装は別ファイル
  2. **ギャラリータイプ定数値**：QS_gallery_SS等の実際の値は設定ファイル依存
  3. **カラーピッカー機能**：JQColorPickerの実装詳細は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_galleryEdit.asp` - ギャラリー編集画面ソースコード（196行）
- E-02: `asp/includes/gallery.asp` - cls_galleryクラス定義（695行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `asp/bs_galleryBack.asp` - 戻るリンク

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_galleryEdit.asp | E-01, E-03 | ○ |
| C-02 | secondAdmin.bGallery権限が必要 | E-01 行4 | ○ |
| C-03 | 保存時にcheckCSRF()が呼ばれる | E-01 行17 | ○ |
| C-04 | gallery.getRequestValues()でフォーム値取得 | E-01 行18, E-02 行194-268 | ○ |
| C-05 | gallery.save()で保存処理 | E-01 行19, E-02 行133-193 | ○ |
| C-06 | 削除時にgallery.remove()が呼ばれる | E-01 行28, E-02 行277-285 | ○ |
| C-07 | sNameの最大長は50文字 | E-01 行44「maxlength=50」, E-02 行151 | ○ |
| C-08 | sCodeは大文字変換される | E-02 行201「ucase(convertStr」 | ○ |
| C-09 | コード重複チェックが行われる | E-02 行124-131 | ○ |
| C-10 | ギャラリータイプにより表示項目が変化 | E-01 行50-106「select case convertStr(gallery.sType)」 | ○ |
| C-11 | Nivoスライダー時にキャプション設定可能 | E-01 行109-177 | ○ |
| C-12 | 画像パス選択で自動送信 | E-01 行46「onchange="javascript:document.mainform.submit();"」 | ○ |
| C-13 | タイプ選択で自動送信 | E-01 行47「onchange="javascript:document.mainform.submit();"」 | ○ |
| C-14 | カスタムリンク変数として[FILENAME],[COUNTER],[PAGEID]が使用可能 | E-01 行106 | ○ |
| C-15 | 保存後にcacheGalleries()が呼ばれる | E-02 行191 | ○ |
| C-16 | 使用箇所検索にcls_fullSearchが使用される | E-01 行186-193 | ○ |
| C-17 | 必須項目未入力でerr_mandatoryエラー | E-02 行111-118 | ○ |
| C-18 | コード重複でerr_doublefeedエラー | E-02 行128 | ○ |
| C-19 | プレビュー成功時にbs_gallerypreview.aspへリダイレクト | E-01 行21 | ○ |
| C-20 | 削除成功時にbs_galleryList.aspへリダイレクト | E-01 行29 | ○ |
| C-21 | 関連機能No.57がギャラリー作成・編集 | E-04 行51 | ○ |
| C-22 | 関連機能No.37がアセットマネージャー | E-04 行52 | ○ |
| C-23 | tblGalleryテーブルに保存 | E-02 行145-189 | ○ |
| C-24 | dCreatedTSは新規作成時のみ設定 | E-02 行147 | ○ |
| C-25 | JQColorPickerの実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- JQColorPicker関数の実装詳細
  - 候補：includes/colorpicker.asp / jQueryプラグイン
- cls_fullSearchクラスの実装詳細
  - 候補：includes/fullSearch.asp
- ギャラリータイプ定数（QS_gallery_SS等）の定義
  - 候補：includes/constants.asp / config/

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ソースコードとの整合性が高い
- **1: 中リスク** - カラーピッカーやサードパーティライブラリの動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各ギャラリータイプでの設定項目表示確認
- [ ] 必須項目バリデーションの動作確認
- [ ] コード重複エラーの動作確認
- [ ] Nivoスライダーのキャプション・URL設定動作確認
- [ ] 使用箇所検索の正確性確認
