---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-ギャラリープレビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. **build()メソッドの複雑なロジック**：約400行の処理があり、全パターンのテストが必要
  2. **画像フォルダ不存在時の動作**：エラーハンドリングの確認
  3. **各ギャラリータイプでのプレビュー表示**：全タイプの動作確認

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_galleryPreview.asp` - ギャラリープレビュー画面ソースコード（7行）
- E-02: `asp/includes/gallery.asp` - cls_galleryクラス定義（695行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_galleryPreview.asp | E-01, E-03 | ○ |
| C-02 | secondAdmin.bGallery権限が必要 | E-01 行4 | ○ |
| C-03 | gallery.backsitePV=trueが設定される | E-01 行6 | ○ |
| C-04 | gallery.build()でHTML生成 | E-01 行7, E-02 行289-677 | ○ |
| C-05 | treatconstants()で変数展開 | E-01 行7 | ○ |
| C-06 | 戻るリンクでbs_galleryList.aspへ遷移 | E-01 行7「bs_galleryList.asp」 | ○ |
| C-07 | 編集ボタンでbs_galleryEdit.aspへ遷移 | E-01 行7「bs_galleryEdit.asp?iGalleryID」 | ○ |
| C-08 | includeNS=trueでNivoスライダー有効化 | E-01 行2 | ○ |
| C-09 | build()内でFileSystemObjectを使用 | E-02 行307 | ○ |
| C-10 | 画像フォルダ不存在時にエラーメッセージ | E-02 行309 | ○ |
| C-11 | 関連機能No.58がギャラリープレビュー | E-04 行53 | ○ |
| C-12 | プレビューモードではナビリンクが非表示 | E-02 行46-60 backsitePV判定 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（本画面はシンプルな構造のため、主要な機能は全てソースコードで確認可能）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 画面自体はシンプルで、複雑なロジックはbuild()メソッドに集約
- **1: 中リスク** - build()メソッドの全パターン（4種類のギャラリータイプ）のテストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] 標準ギャラリータイプのプレビュー表示確認
- [ ] スライドショー（SS）タイプのプレビュー表示確認
- [ ] サイクル（SC）タイプのプレビュー表示確認
- [ ] Nivoスライダー（NS）タイプのプレビュー表示確認
- [ ] 戻るリンク・編集ボタンの遷移確認
- [ ] 画像フォルダ不存在時のエラーメッセージ確認
