---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-カタログ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **customer.catalogsプロパティの実装**：customerオブジェクトの完全な実装は別ファイル
  2. **並び順変更のエッジケース**：最上位/最下位での動作確認
  3. **フィールド0件時の表示制御**：新規アイテムリンクの非表示確認

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_catalogList.asp` - カタログ一覧画面ソースコード（23行）
- E-02: `asp/includes/catalog.asp` - cls_catalogクラス定義（337行）
- E-03: `asp/includes/catalogField.asp` - cls_catalogFieldクラス定義（194行）
- E-04: `asp/includes/catalogFileType.asp` - cls_catalogFileTypeクラス定義（79行）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_catalogList.asp | E-01, E-05 | ○ |
| C-02 | secondAdmin.bCatalog権限が必要 | E-01 行4 | ○ |
| C-03 | MoveUP時にcheckCSRF()が呼ばれる | E-01 行8 | ○ |
| C-04 | MoveDOWN時にcheckCSRF()が呼ばれる | E-01 行11 | ○ |
| C-05 | cf.moveUp()で上方向移動 | E-01 行9, E-03 行139-147 | ○ |
| C-06 | cf.moveDown()で下方向移動 | E-01 行12, E-03 行148-157 | ○ |
| C-07 | customer.catalogsでカタログ一覧取得 | E-01 行14-15 | ○ |
| C-08 | catalogs(key).fields("")でフィールド一覧取得 | E-01 行18, E-02 行244-266 | ○ |
| C-09 | catalogs(key).fileTypesでファイルタイプ一覧取得 | E-01 行19, E-02 行228-243 | ○ |
| C-10 | フィールド1件以上でアイテムリンク表示 | E-01 行19「if fields.count>0」 | ○ |
| C-11 | 新規カタログ作成リンクでbs_catalogEdit.aspへ遷移 | E-01 行15 | ○ |
| C-12 | カタログ名クリックでbs_catalogEdit.asp?iCatalogIDへ遷移 | E-01 行19 | ○ |
| C-13 | 新規アイテムリンクでbs_catalogItemEdit.aspへ遷移 | E-01 行19 | ○ |
| C-14 | 一覧リンクでbs_catalogItemSearch.aspへ遷移 | E-01 行19 | ○ |
| C-15 | フィールド名クリックでbs_catalogFieldEdit.aspへ遷移 | E-01 行19 | ○ |
| C-16 | 新規フィールドリンクでbs_catalogFieldEdit.asp?iCatalogIDへ遷移 | E-01 行19 | ○ |
| C-17 | 新規タイプリンクでbs_catalogFileTypeEdit.asp?iCatalogIDへ遷移 | E-01 行19 | ○ |
| C-18 | カタログ0件時にnocatalogsメッセージ | E-01 行22 | ○ |
| C-19 | 関連機能No.45がカタログ一覧 | E-06 行54 | ○ |
| C-20 | tblCatalogField.iRangで並び順管理 | E-03 行143-154 | ○ |

## 4) 不足情報（Unknown / Missing）
- customer.catalogsプロパティの実装詳細
  - 候補：includes/customer.asp

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] カタログ一覧の正常表示確認
- [ ] フィールド並び順変更（上へ/下へ）の動作確認
- [ ] 最上位フィールドの「上へ」クリック時の動作確認
- [ ] 最下位フィールドの「下へ」クリック時の動作確認
- [ ] フィールド0件時の新規アイテムリンク非表示確認
- [ ] カタログ0件時のメッセージ表示確認
