---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：35-カタログ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **QS_ASPX定数の定義場所**：サムネイル自動生成の条件分岐で使用
  2. **テンプレート変数の展開処理**：treatConstants()関数の実装詳細
  3. **削除時のカスケード処理**：関連データ削除の完全性確認

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_catalogEdit.asp` - カタログ編集画面ソースコード（42行）
- E-02: `asp/includes/catalog.asp` - cls_catalogクラス定義（337行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_catalogEdit.asp | E-01, E-03 | ○ |
| C-02 | secondAdmin.bCatalog権限が必要 | E-01 行4 | ○ |
| C-03 | 保存時にcheckCSRF()が呼ばれる | E-01 行13 | ○ |
| C-04 | catalog.getRequestValues()でフォーム値取得 | E-01 行14, E-02 行163-189 | ○ |
| C-05 | catalog.save()で保存処理 | E-01 行15, E-02 行101-149 | ○ |
| C-06 | 保存後にfbMessage=fb_saveOK付きでリダイレクト | E-01 行15 | ○ |
| C-07 | 削除時にcatalog.remove()が呼ばれる | E-01 行18, E-02 行201-227 | ○ |
| C-08 | 削除後にbs_catalogList.aspへリダイレクト | E-01 行19 | ○ |
| C-09 | sNameとsItemNameが必須 | E-02 行86-93 | ○ |
| C-10 | フォーム選択時にsFormTitleが必須 | E-02 行94-99 | ○ |
| C-11 | サムネイル自動生成チェックで自動送信 | E-01 行29「onclick="javascript:document.mainform.submit();"」 | ○ |
| C-12 | フォーム選択で自動送信 | E-01 行30「onchange="javascript:mainform.submit();"」 | ○ |
| C-13 | 削除時に関連アイテムも削除 | E-02 行210-211 | ○ |
| C-14 | 削除時に関連フィールドも削除 | E-02 行213-214 | ○ |
| C-15 | 削除時に関連ファイルタイプも削除 | E-02 行216-217 | ○ |
| C-16 | 削除時に関連ページのiCatalogIDがnullになる | E-02 行220 | ○ |
| C-17 | 保存後にclearRSSCache()が呼ばれる | E-02 行148 | ○ |
| C-18 | tblCatalogテーブルに保存 | E-02 行112-144 | ○ |
| C-19 | dCreatedTSは新規作成時のみ設定 | E-02 行114 | ○ |
| C-20 | dUpdatedTSは毎回更新 | E-02 行127 | ○ |
| C-21 | 関連機能No.46がカタログ作成・編集 | E-04 行58 | ○ |
| C-22 | QS_ASPX定数の定義場所 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- QS_ASPX定数の定義場所
  - 候補：begin.asp / includes/constants.asp / config/
- treatConstants()関数の実装詳細
  - 候補：includes/functions.asp

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ソースコードとの整合性が高い
- **1: 中リスク** - 削除処理のカスケードが複雑、データ整合性の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 新規カタログ作成の動作確認
- [ ] 既存カタログ編集の動作確認
- [ ] 必須項目バリデーションの動作確認
- [ ] フォーム連携設定時のsFormTitle必須確認
- [ ] サムネイル自動生成設定の表示制御確認
- [ ] 削除時の関連データ削除確認（アイテム、フィールド、ファイルタイプ）
- [ ] 削除後の関連ページのiCatalogID確認
