---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-カタログフィールド編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **新規フィールド追加時の既存アイテムへの追加処理**：大量アイテム時のパフォーマンス
  2. **フィールドタイプ定数の定義**：sb_*定数の定義場所
  3. **削除時の並び順調整**：正確性の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_catalogFieldEdit.asp` - カタログフィールド編集画面ソースコード（23行）
- E-02: `asp/includes/catalogField.asp` - cls_catalogFieldクラス定義（194行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_catalogFieldEdit.asp | E-01, E-03 | ○ |
| C-02 | secondAdmin.bCatalog権限が必要 | E-01 行4 | ○ |
| C-03 | 保存時にcheckCSRF()が呼ばれる | E-01 行13 | ○ |
| C-04 | catalogField.getRequestValues()でフォーム値取得 | E-01 行14, E-02 行104-112 | ○ |
| C-05 | catalogField.save()で保存処理 | E-01 行15, E-02 行56-103 | ○ |
| C-06 | 保存後にbs_catalogList.aspへリダイレクト | E-01 行15 | ○ |
| C-07 | 削除時にcatalogField.remove()が呼ばれる | E-01 行18, E-02 行158-168 | ○ |
| C-08 | sNameとsTypeが必須 | E-02 行41-50 | ○ |
| C-09 | セレクトボックスでsValuesが必須 | E-02 行51-54 | ○ |
| C-10 | 新規時にiRangが自動設定される | E-02 行70-72 | ○ |
| C-11 | 新規時に既存アイテムにフィールド追加 | E-02 行88-102 | ○ |
| C-12 | 削除時にiRangが調整される | E-02 行161 | ○ |
| C-13 | 削除時にtbCatalogItemFieldsから削除 | E-02 行163 | ○ |
| C-14 | タイプ選択で自動送信 | E-01 行22「onchange="javascript:document.mainform.submit();"」 | ○ |
| C-15 | チェックボックスタイプで必須設定非表示 | E-01 行22「if catalogField.sType<>sb_checkbox」 | ○ |
| C-16 | フィールド1件のみで削除ボタン非表示 | E-01 行22「catalogField.catalog.fields("").count>1」 | ○ |
| C-17 | 関連機能No.47がカタログフィールド管理 | E-04 行59 | ○ |
| C-18 | 選択肢は改行区切りで入力 | E-02 行172-177「split(sValues,vbcrlf)」 | ○ |

## 4) 不足情報（Unknown / Missing）
- sb_*定数（フィールドタイプ）の定義場所
  - 候補：begin.asp / includes/constants.asp

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ソースコードとの整合性が高い
- **1: 中リスク** - 大量アイテム存在時の新規フィールド追加パフォーマンス

## 6) レビュアーチェックリスト（最小）
- [ ] 新規フィールド作成の動作確認
- [ ] 既存フィールド編集の動作確認
- [ ] セレクトボックスタイプ選択時の選択肢入力確認
- [ ] チェックボックスタイプ選択時の必須設定非表示確認
- [ ] 新規フィールド追加後の既存アイテムへの反映確認
- [ ] フィールド削除時の並び順調整確認
- [ ] フィールド1件時の削除ボタン非表示確認
