---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：38-カタログアイテム編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **FCKInstance（WYSIWYGエディタ）の実装**：createFCKInstance関数の実装詳細
  2. **フィールド値のDELETE+INSERT方式**：大量データ時のパフォーマンス
  3. **オンライン期間制御**：フロントエンドでの表示制御実装

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_catalogItemEdit.asp` - カタログアイテム編集画面ソースコード（72行）
- E-02: `asp/includes/catalogItem.asp` - cls_catalogItemクラス定義（410行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_catalogItemEdit.asp | E-01, E-03 | ○ |
| C-02 | secondAdmin.bCatalog権限が必要 | E-01 行4 | ○ |
| C-03 | 保存時にcheckCSRF()が呼ばれる | E-01 行17 | ○ |
| C-04 | catalogItem.getRequestValues()でフォーム値取得 | E-01 行18, E-02 行149-167 | ○ |
| C-05 | catalogItem.save()で保存処理 | E-01 行19, E-02 行100-148 | ○ |
| C-06 | 保存後にbs_catalogItemSearch.aspへリダイレクト | E-01 行20 | ○ |
| C-07 | 削除時にcatalogItem.remove()が呼ばれる | E-01 行24, E-02 行175-194 | ○ |
| C-08 | sTitleが必須 | E-02 行82-86 | ○ |
| C-09 | 必須フィールドチェックが行われる | E-02 行87-98 | ○ |
| C-10 | sTitleの最大長は255文字 | E-01 行51「maxlength=250」, E-02 行116「left(sTitle,255)」 | ○ |
| C-11 | フィールド値はDELETE+INSERTで更新 | E-02 行131-145 | ○ |
| C-12 | 削除時にremovePic()が呼ばれる | E-02 行176 | ○ |
| C-13 | 削除時にfiles().remove()が呼ばれる | E-02 行177-181 | ○ |
| C-14 | 削除時にsubmissions().remove()が呼ばれる | E-02 行182-187 | ○ |
| C-15 | 保存後にclearRSSCache()が呼ばれる | E-02 行147 | ○ |
| C-16 | 日付ピッカーが使用される | E-01 行51-52「JQDatePicker」 | ○ |
| C-17 | 動的フィールドがタイプ別に生成される | E-01 行52-53「select case catalogFields(catalogField).sType」 | ○ |
| C-18 | sb_richtextでcreateFCKInstance使用 | E-01 行53 | ○ |
| C-19 | プレビューはsItemView設定時のみ表示 | E-01 行58「if not isLeeg(catalogItem.catalog.sItemView)」 | ○ |
| C-20 | 画像がある場合にshowPic()で表示 | E-01 行68「catalogItem.showPic」 | ○ |
| C-21 | 添付ファイル削除にiFileIDパラメータ使用 | E-01 行11-14 | ○ |
| C-22 | 関連機能No.48がカタログアイテム管理 | E-04 行61 | ○ |
| C-23 | 関連機能No.51が画像アップロード | E-04 行62 | ○ |
| C-24 | 関連機能No.52がファイルアップロード | E-04 行63 | ○ |
| C-25 | createFCKInstance関数の実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- createFCKInstance関数の実装詳細
  - 候補：includes/fck.asp / エディタ関連ファイル
- オンライン期間制御のフロントエンド実装
  - 候補：process_catalog.asp / default.asp

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ソースコードとの整合性が高い
- **1: 中リスク** - 大量フィールド時のDELETE+INSERT方式のパフォーマンス

## 6) レビュアーチェックリスト（最小）
- [ ] 新規アイテム作成の動作確認
- [ ] 既存アイテム編集の動作確認
- [ ] 各フィールドタイプ（text/textarea/checkbox/select/date/richtext）の入力確認
- [ ] 必須フィールドバリデーションの動作確認
- [ ] 画像アップロード・削除の動作確認
- [ ] 添付ファイルアップロード・削除の動作確認
- [ ] アイテム削除時の関連データ削除確認
- [ ] プレビュー表示の動作確認
