---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：39-カタログアイテム検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **cls_itemSearchクラスの実装詳細**：resultTableプロパティの実装
  2. **Excel出力処理**：具体的な出力形式・処理
  3. **オンライン状態判定ロジック**：dOnlineFrom/dOnlineUntillによる判定

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_catalogItemSearch.asp` - カタログアイテム検索画面ソースコード（31行）
- E-02: `asp/includes/catalogItem.asp` - cls_catalogItemクラス定義（410行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_catalogItemSearch.asp | E-01, E-03 | ○ |
| C-02 | secondAdmin.bCatalog権限が必要 | E-01 行4 | ○ |
| C-03 | カタログ選択変更で自動送信 | E-01 行21「onchange="javascript:document.mainform.submit();"」 | ○ |
| C-04 | catalog.fields("search")で検索フィールド取得 | E-01 行7 | ○ |
| C-05 | itemSearch.getRequestValues()で検索条件取得 | E-01 行9 | ○ |
| C-06 | itemSearch.resultTableで検索結果表示 | E-01 行29 | ○ |
| C-07 | コピー処理でcatalogItem.copy()が呼ばれる | E-01 行19、E-02 行385-406 | ○ |
| C-08 | コピー後にリダイレクトでアンカー付き | E-01 行20「#"&encrypt(catalogItem.iId)」 | ○ |
| C-09 | 動的検索フォームがフィールドタイプ別に生成 | E-01 行22-24 | ○ |
| C-10 | 日付型は範囲検索（from/untill） | E-01 行23-24 | ○ |
| C-11 | 新規アイテムリンクはフィールド1件以上で表示 | E-01 行27-28「if isNumeriek(itemSearch.iCatalogID) and itemSearch.catalog.fields("").count>0」 | ○ |
| C-12 | btnaction=検索で検索実行 | E-01 行25「btnaction」 | ○ |
| C-13 | btnaction=Excelで出力 | E-01 行25 | ○ |
| C-14 | オンライン/オフライン凡例表示 | E-01 行30「convertTF」 | ○ |
| C-15 | copy()で画像ファイルもコピー | E-02 行396-404 | ○ |
| C-16 | copy()でsTitleに「のコピー」追加 | E-02 行390 | ○ |
| C-17 | 関連機能No.49がカタログアイテム検索 | E-04 行64 | ○ |
| C-18 | cls_itemSearchクラスの実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_itemSearchクラスの実装詳細
  - 候補：includes/itemSearch.asp
- Excel出力処理の実装詳細
  - 候補：cls_itemSearchクラス内またはbs_catalogItemExcel.asp

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ソースコードとの整合性が高い
- **1: 中リスク** - 検索処理の実装詳細がcls_itemSearchに依存

## 6) レビュアーチェックリスト（最小）
- [ ] カタログ選択の動作確認
- [ ] 各フィールドタイプでの検索動作確認
- [ ] 日付範囲検索の動作確認
- [ ] 検索結果一覧のオンライン/オフライン表示確認
- [ ] アイテムコピー機能の動作確認
- [ ] Excel出力機能の動作確認
- [ ] 新規アイテムリンクの表示条件確認
