---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-管理者ログオフ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目で根拠確認済み）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_logoff.asp` 行1-5
- E-02: `asp/includes/logonEdit.asp` 行175-182
- E-03: `asp/ad_security.asp` 行1-3
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 行5
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行8

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは asp/ad_logoff.asp である | E-04 | ○ |
| C-02 | logon.logoff関数が呼び出される | E-01 行4 | ○ |
| C-03 | Cookie「sEmail」がクリアされる | E-02 行176 | ○ |
| C-04 | Cookie「sPw」がクリアされる | E-02 行177 | ○ |
| C-05 | adminLoginCount試行回数がリセットされる | E-02 行178 | ○ |
| C-06 | Session(isAUTHENTICATEDasADMIN)がfalseになる | E-02 行179 | ○ |
| C-07 | Session(isAUTHENTICATEDasUSER)がfalseになる | E-02 行180 | ○ |
| C-08 | Session(isAUTHENTICATEDSecondAdmin)がfalseになる | E-02 行181 | ○ |
| C-09 | ad_security.aspがインクルードされる | E-01 行4 | ○ |
| C-10 | bUseArtLoginTemplateがtrue設定 | E-01 行4 | ○ |
| C-11 | youareloggedoffメッセージが表示される | E-01 行4 | ○ |
| C-12 | loginagainリンクが表示される | E-01 行4 | ○ |
| C-13 | 多言語対応されている（l関数使用） | E-01 行4 | ○ |
| C-14 | リンク先はQS_admin_login_page | E-01 行4 | ○ |
| C-15 | 未認証時はnoaccess.htmへリダイレクト | E-03 行3 | ○ |
| C-16 | 機能No.2「管理者ログアウト」に対応 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に対して根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな処理であり、実装も明確
- 0: 低リスク - 全項目で根拠が確認されている
- 0: 低リスク - バックサイトログオフとの差異も明確

## 6) レビュアーチェックリスト（最小）
- [ ] ad_logoff.aspの処理フローが設計書と一致しているか確認
- [ ] logoff関数の処理内容を確認
- [ ] ad_security.aspの認証チェックを確認
- [ ] リダイレクトなしでメッセージ表示されることを確認
