---
generated_at: 2026-01-23 22:15:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：44-購読者一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **PCase関数の定義場所**：VBScript共通関数の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_newsletterSubscribers.asp` 1-137行目
- E-02: `asp/includes/newsletterCategory.asp` 100-105行目（nmbrSubscribersプロパティ）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 44行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 72行目
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` ニュースレター画面遷移セクション

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 購読者一覧を表示する画面である | E-01, E-03 | ○ |
| C-02 | アクセスにはsecondAdmin.bNewsletter権限が必要 | E-01 4行目 | ○ |
| C-03 | カテゴリで絞り込み可能 | E-01 17行目「iCategoryID」 | ○ |
| C-04 | 名前でLIKE検索可能 | E-01 47-49行目「sName like」 | ○ |
| C-05 | メールでLIKE検索可能 | E-01 50-52行目「sEmail like」 | ○ |
| C-06 | アクティブ状態でフィルタリング可能 | E-01 36-44行目「select case bActive」 | ○ |
| C-07 | 最大2500件まで表示 | E-01 104行目「subCounter<2500」、118行目警告 | ○ |
| C-08 | カテゴリが1つなら自動選択 | E-01 19-24行目 | ○ |
| C-09 | SetChecked関数で全選択/解除 | E-01 5-13行目 | ○ |
| C-10 | deleteIDで複数選択削除 | E-01 27-35行目「for each delID」 | ○ |
| C-11 | tblNewsletterLogも連動削除 | E-01 29-30行目 | ○ |
| C-12 | tblNewsletterCategorySubscriberから削除 | E-01 32-33行目 | ○ |
| C-13 | pcase="1"でProper Case処理 | E-01 56-67行目 | ○ |
| C-14 | PCase関数で名前変換 | E-01 61行目「PCase(convertStr(rs("sName")))」 | ○ |
| C-15 | 一括購読解除はテキストエリアから入力 | E-01 126行目「textarea name="unsubscribers"」 | ○ |
| C-16 | 改行で分割してメール検索 | E-01 81行目「split(request.form("unsubscribers"),vbcrlf)」 | ○ |
| C-17 | bActive=falseで購読解除 | E-01 87-88行目 | ○ |
| C-18 | カテゴリ選択時のみ一括購読解除表示 | E-01 122行目「if convertGetal(iCategoryID)<>0」 | ○ |
| C-19 | bCanImportSubscribers時にImportボタン表示 | E-01 14行目「if customer.bCanImportSubscribers」 | ○ |
| C-20 | 総購読者数をcountで取得 | E-01 46行目「select count(*)」 | ○ |
| C-21 | sName昇順でソート | E-01 75行目「order by sName」 | ○ |
| C-22 | 名前は最大40文字表示 | E-01 107行目「left(quotrep(rs("sName")),40)」 | ○ |
| C-23 | メールはmailto:リンク付き | E-01 108行目「href=""mailto:」 | ○ |
| C-24 | jaNeen関数でYes/No表示 | E-01 109行目「jaNeen(convertBool(rs("bActive")))」 | ○ |
| C-25 | 編集リンクでbs_newsletterSubscriber.aspに遷移 | E-01 111行目 | ○ |
| C-26 | 2500件超過時にJavaScript警告 | E-01 119行目「alert('Warning!...」 | ○ |
| C-27 | 削除確認ダイアログ表示 | E-01 102行目「confirm('Are you sure to delete」 | ○ |
| C-28 | Proper Case確認ダイアログ表示 | E-01 102行目「confirm('Do you wish to proper case」 | ○ |
| C-29 | 一括購読解除確認ダイアログ表示 | E-01 128行目「confirm('Are you sure to unsubscribe」 | ○ |
| C-30 | PCase関数の定義場所 | **定義ファイル未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- PCase関数の定義箇所
  - 候補：begin.asp / common.asp / VBScript組み込み関数

## 5) リスクフラグ（レビュー観点）
- 0: 検索条件はcleanup()関数でサニタイズ
- 0: 削除前に確認ダイアログが表示される
- 1: on error resume nextによるエラー無視がある（105行目）
- 1: 一括購読解除のメールアドレス検証が不明確

## 6) レビュアーチェックリスト（最小）
- [ ] PCase関数の定義箇所と動作確認
- [ ] cleanup関数のSQLインジェクション対策確認
- [ ] 一括購読解除時のメールアドレス形式検証確認
- [ ] 2500件制限の妥当性確認（パフォーマンステスト）
