---
generated_at: 2026-01-23 22:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-カテゴリ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_newsletterCategoryList.asp` 1-7行目
- E-02: `asp/includes/newsletterCategory.asp` 100-105行目（nmbrSubscribersプロパティ）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 47行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 75行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メーリングリスト（カテゴリ）一覧を表示する画面である | E-01, E-03 | ○ |
| C-02 | アクセスにはsecondAdmin.bNewsletter権限が必要 | E-01 4行目 | ○ |
| C-03 | 「Create new Email list」ボタンで新規作成画面へ遷移 | E-01 5行目「href="bs_NewsletterCategoryEdit.asp"」 | ○ |
| C-04 | 「Newsletter home」ボタンでニュースレター一覧へ遷移 | E-01 5行目「href="bs_newsletterList.asp"」 | ○ |
| C-05 | customer.NewsletterCategoriesから一覧取得 | E-01 5行目「set NewsletterCategories=customer.NewsletterCategories」 | ○ |
| C-06 | NewsletterCategories.count>0で条件分岐 | E-01 5行目「if NewsletterCategories.count>0 then」 | ○ |
| C-07 | for eachでカテゴリをループ | E-01 6行目「for each NewsletterKey in NewsletterCategories」 | ○ |
| C-08 | カテゴリ名は編集画面へのリンク | E-01 6行目「href="bs_NewsletterCategoryEdit.asp?iNewsletterCategoryID="」 | ○ |
| C-09 | 購読者数は購読者一覧へのリンク | E-01 6行目「href="bs_newsletterSubscribers.asp?iCategoryID="」 | ○ |
| C-10 | nmbrSubscribersで購読者数取得 | E-01 6行目、E-02 100-105行目 | ○ |
| C-11 | nmbrSubscribersはbActive=trueのみカウント | E-02 102行目「bActive=" & getSQLBoolean(true)」 | ○ |
| C-12 | テンプレートタグ[QS_NLCAT_{ID}]を表示 | E-01 6行目「[QS_NLCAT_<%=Newsletterkey%>]」 | ○ |
| C-13 | タグ入力欄はクリックで全選択 | E-01 6行目「onclick="javascript:this.select()"」 | ○ |
| C-14 | カテゴリ0件時は「No lists yet...」表示 | E-01 6行目「else」部分 | ○ |
| C-15 | iNewsletterCategoryIDは暗号化 | E-01 6行目「encrypt(Newsletterkey)」 | ○ |
| C-16 | iCategoryIDは暗号化 | E-01 6行目「encrypt(Newsletterkey)」 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: シンプルな一覧表示画面のため、リスクは低い
- 0: データベース更新処理なし

## 6) レビュアーチェックリスト（最小）
- [ ] customer.NewsletterCategoriesの取得SQLを確認
- [ ] テンプレートタグ[QS_NLCAT_{ID}]のフロントエンド動作を確認
