---
generated_at: 2026-01-23 22:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-カテゴリ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_newsletterCategoryEdit.asp` 1-20行目
- E-02: `asp/includes/newsletterCategory.asp` 2-185行目
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 48行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 76行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ニュースレターカテゴリを編集する画面である | E-01, E-03 | ○ |
| C-02 | アクセスにはsecondAdmin.bNewsletter権限が必要 | E-01 4行目 | ○ |
| C-03 | iNewsletterCategoryIDがない場合は新規作成モード | E-02 13行目 Class_Initialize | ○ |
| C-04 | postBackフラグで処理分岐 | E-01 7行目 | ○ |
| C-05 | btnaction="delete"で削除処理 | E-01 8-11行目 | ○ |
| C-06 | newsletterCategory.remove()で削除実行 | E-01 9行目、E-02 91-99行目 | ○ |
| C-07 | 削除後はカテゴリ一覧にリダイレクト | E-01 10行目「Response.Redirect」 | ○ |
| C-08 | getRequestValues()でフォーム値取得 | E-01 13行目、E-02 16-25行目 | ○ |
| C-09 | checkCSRF()でCSRF検証 | E-01 14行目 | ○ |
| C-10 | newsletterCategory.save()で保存処理 | E-01 15行目、E-02 60-90行目 | ○ |
| C-11 | 保存成功時はmessage.Add("fb_saveOK") | E-01 16行目 | ○ |
| C-12 | check()でsNameの必須チェック | E-02 47-50行目 | ○ |
| C-13 | check()でsUnsubscribeFBの必須チェック | E-02 51-54行目 | ○ |
| C-14 | check()でsUnsubscribeFBTitleの必須チェック | E-02 55-58行目 | ○ |
| C-15 | sNameは最大50文字 | E-02 17行目「left(...,50)」 | ○ |
| C-16 | sErrorMessageは最大255文字 | E-02 23行目「left(...,255)」 | ○ |
| C-17 | 削除時は購読者も全削除 | E-02 94行目「delete from tblNewsletterCategorySubscriber」 | ○ |
| C-18 | デフォルト購読フォームテンプレートが設定される | E-02 6行目 Class_Initialize | ○ |
| C-19 | {ID}、{N}、{E}などのプレースホルダー使用可能 | E-02 117-123行目 build() | ○ |
| C-20 | [NL_NAME]、[NL_EMAIL]変数が使用可能 | E-02 177-178行目 registerNameAndEmail | ○ |
| C-21 | createFCKInstanceでWYSIWYGエディタ生成 | E-01 18行目 | ○ |
| C-22 | siteBuilderRichTextモードでエディタ設定 | E-01 18行目「siteBuilderRichText」 | ○ |
| C-23 | 既存カテゴリのみ削除ボタン表示 | E-01 19行目「if isNumeriek(newsletterCategory.iID)」 | ○ |
| C-24 | 削除確認ダイアログ表示 | E-01 19行目「confirm」 | ○ |
| C-25 | 戻るリンクでカテゴリ一覧に遷移 | E-01 18行目、19行目 href | ○ |
| C-26 | sNotifEmailは最大50文字 | E-02 24行目「left(...,50)」 | ○ |
| C-27 | sUnsubscribeFBTitleは最大50文字 | E-02 20行目「left(...,50)」 | ○ |
| C-28 | iCustomerIDはcIdで設定 | E-02 79行目「rs("iCustomerID") = cId」 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: CSRF対策が実装されている
- 0: 入力値の長さ制限が適切に設定されている
- 1: 購読フォームHTML（sSignupForm）のXSS対策確認が必要
- 1: 削除時の購読者全削除について警告が十分か確認

## 6) レビュアーチェックリスト（最小）
- [ ] sSignupFormに入力されるHTMLのXSS対策を確認
- [ ] 削除確認ダイアログのメッセージに購読者削除の警告が含まれているか確認
- [ ] WYSIWYGエディタの入力値サニタイズを確認
