---
generated_at: 2026-01-23 22:40:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-配信編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_newsletterMailingEdit.asp` 1-46行目
- E-02: `asp/includes/newsletterMailing.asp` 2-123行目
- E-03: `asp/includes/newsletter.asp` 139-170行目（send()メソッド）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 49行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 77行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ニュースレター配信設定を行う画面である | E-01, E-04 | ○ |
| C-02 | アクセスにはsecondAdmin.bNewsletter権限が必要 | E-01 4行目 | ○ |
| C-03 | iNewsletterMailingIDがない場合は新規作成モード | E-02 7行目 Class_Initialize | ○ |
| C-04 | postBackフラグで処理分岐 | E-01 11行目 | ○ |
| C-05 | btnaction="delete"で削除処理 | E-01 6-9行目 | ○ |
| C-06 | newsletterMailing.remove()で削除実行 | E-01 7行目、E-02 76-84行目 | ○ |
| C-07 | 削除後はニュースレター一覧にリダイレクト | E-01 8行目「Response.Redirect」 | ○ |
| C-08 | getRequestValues()でフォーム値取得 | E-01 13行目、E-02 10-14行目 | ○ |
| C-09 | checkCSRF()でCSRF検証 | E-01 14行目 | ○ |
| C-10 | newsletterMailing.save()で保存処理 | E-01 15行目、E-02 41-67行目 | ○ |
| C-11 | btnaction="send"でプレビュー送信 | E-01 18-19行目 | ○ |
| C-12 | newsletterMailing.Newsletter.send()でプレビュー | E-01 19行目、E-02 68-71行目 | ○ |
| C-13 | 続行時は配信送信画面にリダイレクト | E-01 21行目「response.redirect("bs_newsletterMailingSend.asp」 | ○ |
| C-14 | check()でiNewsletterIDの必須チェック | E-02 32-35行目 | ○ |
| C-15 | check()でsCategoryの必須チェック | E-02 36-39行目 | ○ |
| C-16 | カテゴリが1つなら自動チェック | E-01 34-36行目「if NewsletterCategories.count=1」 | ○ |
| C-17 | カテゴリはラジオボタンで選択 | E-01 33行目「type=""radio""」 | ○ |
| C-18 | 各カテゴリに購読者数を表示 | E-01 43行目「nmbrSubscribers」 | ○ |
| C-19 | プレビュー送信先デフォルトはcustomer.webmaster | E-01 25-27行目 | ○ |
| C-20 | 削除時はtblNewsletterLogも削除 | E-02 79行目「delete from tblNewsletterLog」 | ○ |
| C-21 | 削除時はtblNewsletterMailingから削除 | E-02 81行目「delete from tblNewsletterMailing」 | ○ |
| C-22 | 既存配信のみ削除ボタン表示 | E-01 45行目「if isNumeriek(newsletterMailing.iID)」 | ○ |
| C-23 | 削除確認ダイアログ表示 | E-01 45行目「confirm」 | ○ |
| C-24 | customer.showSelectedNewsletterでニュースレター選択肢生成 | E-01 28行目 | ○ |
| C-25 | bLogフラグで配信履歴保存を制御 | E-01 44行目、E-02 13, 61行目 | ○ |
| C-26 | プレビュー送信成功時は「Preview was sent!」表示 | E-01 44行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: CSRF対策が実装されている
- 0: 必須項目チェックが実装されている
- 0: 削除前に確認ダイアログが表示される

## 6) レビュアーチェックリスト（最小）
- [ ] customer.showSelectedNewsletter関数の実装確認
- [ ] 配信送信画面（bs_newsletterMailingSend.asp）との連携確認
- [ ] bLogフラグによる開封追跡の動作確認
