---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：5-バックサイトホーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **menu.aspのgetBOMenu関数詳細**：キャッシュロジックの詳細確認が必要
  2. **ページコピー時の全カラム処理**：copy関数の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_default.asp` 行1-16
- E-02: `asp/bs_security.asp` 行1-79
- E-03: `asp/bs_process.asp` 行1-214
- E-04: `asp/bs_menu.asp` 行1-27
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 行6
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行9-12
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` 行40-95

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは asp/bs_default.asp である | E-05 | ○ |
| C-02 | ログイン成功後に自動遷移 | E-07 行31 | ○ |
| C-03 | secondAdmin.bPagesAddで新規ページ表示制御 | E-01 行4, E-02 行40 | ○ |
| C-04 | secondAdmin.bHomeConstantsで定数リンク表示制御 | E-01 行4 | ○ |
| C-05 | secondAdmin.bHomeVBScriptでスクリプトリンク表示制御 | E-01 行4, E-02 行23-27 | ○ |
| C-06 | customer.bApplicationでスクリプト機能有効化 | E-01 行4 | ○ |
| C-07 | bs_menu.aspでページツリー生成 | E-01 行4, E-04 | ○ |
| C-08 | copyItem関数でコピー確認 | E-01 行5-14 | ○ |
| C-09 | getBOHeader関数でヘッダー生成 | E-01 行4 | ○ |
| C-10 | getArtLink関数でリンク生成 | E-01 行4 | ○ |
| C-11 | bs_setupPage.aspへ新規ページリンク | E-01 行4 | ○ |
| C-12 | bs_constantlist.aspへ定数リンク | E-01 行4 | ○ |
| C-13 | bs_scriptlist.aspへスクリプトリンク | E-01 行4 | ○ |
| C-14 | bs_search.aspへ検索リンク | E-01 行4 | ○ |
| C-15 | bs_validatepages.aspへ検証リンク | E-01 行4 | ○ |
| C-16 | pagesTobeValidatedで検証待ち判定 | E-01 行4 | ○ |
| C-17 | Copy処理がbs_process.aspで定義 | E-03 行65-73 | ○ |
| C-18 | MoveUp処理がbs_process.aspで定義 | E-03 行20-27 | ○ |
| C-19 | MoveDown処理がbs_process.aspで定義 | E-03 行28-35 | ○ |
| C-20 | Application変数でメニューキャッシュ | E-04 行4-6 | ○ |
| C-21 | lossePaginas関数でフリーページ取得 | E-04 行8-24 | ○ |
| C-22 | secondAdmin.bPagesPWでパスワードアイコン制御 | E-04 行17-19 | ○ |
| C-23 | secondAdmin.bPagesMoveで移動アイコン制御 | E-04 行20 | ○ |
| C-24 | secondAdmin.bApplicationpathでアプリアイコン制御 | E-04 行15 | ○ |
| C-25 | areyousuretocopyメッセージが使用される | E-01 行7 | ○ |
| C-26 | 機能No.8「ページ一覧」に対応 | E-06 | ○ |
| C-27 | 機能No.97「バックオフィス検索」に対応 | E-06 | ○ |
| C-28 | セカンド管理者以外のみ検索リンク表示 | E-01 行4 | ○ |
| C-29 | getBOMenu関数の詳細実装 | **menu.asp未詳細確認** | △ |
| C-30 | ページコピー時の全カラム処理詳細 | **page.aspのcopy関数未詳細確認** | △ |

## 4) 不足情報（Unknown / Missing）
- menu.aspのgetBOMenu関数の詳細実装
  - 候補：`asp/includes/menu.asp` / ツリー構築アルゴリズム / 再帰処理
- page.aspのcopy関数の詳細実装
  - 候補：`asp/includes/page.asp` / 子ページのコピー処理 / 関連データのコピー

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成、リンク先、基本フローは実装と一致
- 0: 低リスク - 権限制御ロジックは確認済み
- 1: 中リスク - メニューキャッシュの更新タイミング確認が必要
- 1: 中リスク - ページコピー時の関連データ処理の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] bs_default.aspの画面構成が設計書と一致しているか確認
- [ ] bs_menu.aspのツリー生成ロジックを確認
- [ ] bs_process.aspの各処理（Copy、Move等）を確認
- [ ] secondAdmin権限による表示制御を確認
- [ ] Application変数によるキャッシュの動作を確認
- [ ] フリーページ表示の動作を確認
