---
generated_at: 2026-01-23 22:45:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-配信送信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_newsletterMailingSend.asp` 1-93行目
- E-02: `asp/includes/newsletterMailing.asp` 2-123行目
- E-03: `asp/includes/newsletter.asp` 139-170行目（send()メソッド）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 50行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 78行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ニュースレター配信を実行する画面である | E-01, E-04 | ○ |
| C-02 | アクセスにはsecondAdmin.bNewsletter権限が必要 | E-01 4行目 | ○ |
| C-03 | iIntervalのデフォルトは10件 | E-01 16行目「iInterval=10」 | ○ |
| C-04 | iForceReloadのデフォルトは15秒 | E-01 17行目「iIntervalS=15」 | ○ |
| C-05 | postBack=trueで送信処理開始 | E-01 25行目「if postback then」 | ○ |
| C-06 | sCategoryをカンマ区切りで分割 | E-01 22行目「arrC=split(newsletterMailing.sCategory,\",\")」 | ○ |
| C-07 | bActive=trueの購読者のみ取得 | E-01 29行目「bActive=\" & getSQLBoolean(true)」 | ○ |
| C-08 | iStart=0で開始時刻をセッションに記録 | E-01 30-32行目「session(\"NLstartTime\")」 | ○ |
| C-09 | bLog=trueの場合tblNewsletterLogに挿入 | E-01 40-53行目 | ○ |
| C-10 | sKeyにgeneratePasswordで生成 | E-01 49行目「rsI(\"sKey\") = generatePassword」 | ○ |
| C-11 | sAddImageUrlで追跡用URLを生成 | E-01 51行目「sAddImageUrl=customer.sQSUrl & \"/default.asp?pageAction=rlog&k=\"」 | ○ |
| C-12 | newsletter.send()でメール送信 | E-01 57行目「newsletter.send rs(\"sName\"),ccEmail, rs(\"sKey\")」 | ○ |
| C-13 | allEmailsで重複メール防止 | E-01 39行目「if not allEmails.exists(ccEmail)」、58行目「allEmails.add」 | ○ |
| C-14 | rs.eofで送信完了を判定 | E-01 65行目「if rs.eof then」 | ○ |
| C-15 | 完了時にsession("NLstopTime")に記録 | E-01 66行目「session(\"NLstopTime\")」 | ○ |
| C-16 | bLog=trueの場合dSentDateを更新して保存 | E-01 67-70行目「newsletterMailing.dSentDate=now()」「save()」 | ○ |
| C-17 | 完了時sent=1でリダイレクト | E-01 71行目「response.redirect...&sent=1&」 | ○ |
| C-18 | META HTTP-EQUIVリフレッシュで自動継続 | E-01 85行目「<META HTTP-EQUIV=\"\"refresh\"\" CONTENT=」 | ○ |
| C-19 | 送信件数選択は1-100 | E-01 88行目「numberList(1,100,1,iInterval)」 | ○ |
| C-20 | 送信間隔選択は3-600秒（3秒刻み） | E-01 88行目「numberList(3,600,3,iIntervalS)」 | ○ |
| C-21 | 送信確認ダイアログを表示 | E-01 88行目「confirm('Are you sure to send the mailing now?')」 | ○ |
| C-22 | 確認後ボタンを無効化 | E-01 88行目「this.disabled=true」 | ○ |
| C-23 | sent=""で送信確認フォーム表示 | E-01 87-88行目「case \"\"」 | ○ |
| C-24 | sent="0"で送信中メッセージ表示 | E-01 89行目「case \"0\"」 | ○ |
| C-25 | sent="1"で完了メッセージ表示 | E-01 89行目「case \"1\"」 | ○ |
| C-26 | bLog=trueの場合配信履歴リンク表示 | E-01 89行目「if newsletterMailing.bLog then」「bs_newsletterMailingHistory.asp」 | ○ |
| C-27 | bLog=falseの場合配信設定削除 | E-01 90行目「newsletterMailing.remove()」 | ○ |
| C-28 | remove()でtblNewsletterLogを削除 | E-02 79行目「delete from tblNewsletterLog」 | ○ |
| C-29 | remove()でtblNewsletterMailingを削除 | E-02 81行目「delete from tblNewsletterMailing」 | ○ |
| C-30 | tblNewsletterLogにiSubscriberID, iMailingID, bRead, dWhen, sKeyを保存 | E-01 45-49行目 | ○ |
| C-31 | convert2()で時刻を2桁表示 | E-01 31行目、66行目「convert2(hour(time))」 | ○ |
| C-32 | totalは選択カテゴリの購読者数合計 | E-01 76-80行目「total=total+NewsletterCategories...nmbrSubscribers」 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: ニュースレター送信権限チェックが実装されている
- 0: 送信確認ダイアログで誤操作防止
- 1: 送信中断時の再開で重複送信の可能性あり（iStartで再開可能だが、同一購読者への重複確認はallEmailsのみで、セッション跨ぎでは未対応）
- 1: 大量送信時のメールサーバー負荷考慮が必要

## 6) レビュアーチェックリスト（最小）
- [ ] newsletter.send()メソッドの実装確認（メール送信処理）
- [ ] generatePassword関数のランダム性確認（追跡キー生成）
- [ ] 送信中断後の再開時の重複送信リスク評価
- [ ] メールサーバーの送信制限との整合性確認
- [ ] 開封追跡ビーコン（default.asp?pageAction=rlog）の実装確認
