---
generated_at: 2026-01-23 22:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：51-配信履歴

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **開封トラッキングの仕組み**：追跡用画像の実装詳細が未確認
  2. **権限チェック詳細**：secondAdmin.bNewsletterの定義箇所未確認
  3. **配信日の降順表示**：SQLで確認済みだが画面上の表示順の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_newsletterMailingHistory.asp` 行1-23
- E-02: `asp/includes/newsletterMailing.asp` 行1-123
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行52
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行79
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` 行119-146

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ニュースレター配信履歴を一覧表示する | E-01（行10-21） | ○ |
| C-02 | 配信日、ニュースレター名、メールリストを表示 | E-01（行11） | ○ |
| C-03 | 総配信数、開封数、未開封数を表示 | E-02（行85-101） | ○ |
| C-04 | 開封率・未開封率をパーセンテージで表示 | E-01（行16-18） | ○ |
| C-05 | 詳細クリックで購読者一覧を表示 | E-02（行102-122） | ○ |
| C-06 | 削除時に確認ダイアログを表示 | E-01（行19） | ○ |
| C-07 | tblNewsletterMailingを使用 | E-01（行10）, E-02（行18） | ○ |
| C-08 | tblNewsletterLogを使用 | E-02（行79-81, 90-94） | ○ |
| C-09 | secondAdmin.bNewsletter権限チェック | E-01（行4） | ○ |
| C-10 | bs_NewsletterList.aspに戻るリンク | E-01（行4, 22） | ○ |
| C-11 | 削除時にログも削除される | E-02（行78-83） | ○ |
| C-12 | iCustomerIDでフィルタリング | E-01（行10）, E-02（行18） | ○ |
| C-13 | 配信日降順で表示 | E-01（行10 "order by dSentDate desc"） | ○ |
| C-14 | 暗号化されたIDを使用 | E-01（行19 encrypt関数使用） | ○ |
| C-15 | t=0で全件、t=1で開封、t=2で未開封 | E-02（行88-95, 106-113） | ○ |
| C-16 | cls_newsletterMailingクラスを使用 | E-02（行2-123） | ○ |
| C-17 | newsletter、categoryプロパティで関連取得 | E-02（行68-75） | ○ |
| C-18 | 開封トラッキングは追跡用画像で実現 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 開封トラッキングの具体的な実装（追跡用画像の埋め込み箇所）
  - 候補：メール送信処理 / ニュースレター編集画面 / フロントエンド処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は正確
- 1: 中リスク - 開封トラッキングの技術詳細は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] 削除処理が正しくログも含めて削除されることを確認
- [ ] 開封トラッキングの実装詳細を確認（追跡画像の配置場所）
- [ ] 権限チェックが適切に動作することを確認
- [ ] 暗号化・復号化の一貫性を確認
