---
generated_at: 2026-01-23 22:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：52-連絡先ホーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **manyContacts設定値**：設定値の確認（begin.aspで500と定義）
  2. **ステータス色分けCSS**：CSSファイルの確認が必要
  3. **Gravatar連携**：md5ハッシュ計算の実装確認

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_contactHome.asp` 行1-31
- E-02: `asp/includes/contact.asp` 行1-596
- E-03: `asp/includes/contactField.asp` 行1-186
- E-04: `asp/includes/contactSearch.asp` 行1-326
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 行53-54
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行80-81
- E-07: `asp/begin.asp` 行40（manyContacts=500）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カスタムフィールドによる検索機能を提供 | E-01（行23-26）, E-04（行82-95） | ○ |
| C-02 | テキスト、日付範囲、チェックボックス、セレクトの検索 | E-01（行23-26） | ○ |
| C-03 | メールアドレス・ニックネームによる検索 | E-01（行26）, E-04（行72-77） | ○ |
| C-04 | 会員ロールによるフィルタリング | E-01（行26）, E-04（行78-79） | ○ |
| C-05 | Excel出力機能 | E-04（行219-224） | ○ |
| C-06 | 選択した会員への一括メール送信 | E-01（行27） | ○ |
| C-07 | secondAdmin.bIntranetContacts権限チェック | E-01（行4） | ○ |
| C-08 | secondAdmin.bIntranetMail権限で一括メール表示制御 | E-01（行27） | ○ |
| C-09 | 5段階のステータス管理 | E-04（行228-239） | ○ |
| C-10 | ステータスの色分け表示 | E-04（行248） | ○ |
| C-11 | アバター表示（Gravatar対応） | E-04（行262-264）, E-02（行541-544） | ○ |
| C-12 | ページサイズ選択（大量連絡先時） | E-01（行26）, E-04（行21-30） | ○ |
| C-13 | bs_contactEdit.aspへ遷移 | E-01（行21） | ○ |
| C-14 | bs_contactFields.aspへ遷移 | E-01（行22） | ○ |
| C-15 | bs_tickets.aspへ遷移 | E-01（行23） | ○ |
| C-16 | bs_contactSelectionActions.aspへ遷移 | E-01（行27） | ○ |
| C-17 | colorboxでポップアップ表示 | E-01（行27-30） | ○ |
| C-18 | customer.contactFields()でフィールド取得 | E-01（行5-8） | ○ |
| C-19 | cls_contactSearchで検索実行 | E-01（行9-16）, E-04 | ○ |
| C-20 | tblContact, tblContactValues, tblContactFieldを使用 | E-04（行65-68） | ○ |
| C-21 | 日付検索はbetween条件で実装 | E-04（行96-119） | ○ |
| C-22 | ステータス色分けCSSクラス定義 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ステータス色分け用CSSの定義箇所
  - 候補：includes/css.asp / テンプレートCSS / インラインスタイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は正確
- 1: 中リスク - CSSによる色分けの実装詳細は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] カスタムフィールド検索が正しく動作することを確認
- [ ] Excel出力ファイルの形式・内容を確認
- [ ] 一括メール送信の動作確認
- [ ] ステータス色分けのCSS定義を確認
- [ ] 大量データ時のパフォーマンスを確認
