---
generated_at: 2026-01-23 22:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-連絡先フィールド一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_contactFields.asp` 行1-18
- E-02: `asp/includes/contactField.asp` 行1-186
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行55
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行83

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カスタムフィールド一覧を表示 | E-01（行16-17） | ○ |
| C-02 | フィールド名、タイプ、各フラグを表示 | E-01（行17） | ○ |
| C-03 | フィールドの並び順変更機能 | E-01（行7-13）, E-02（行137-156） | ○ |
| C-04 | 新規フィールド作成画面へ遷移 | E-01（行17） | ○ |
| C-05 | 既存フィールド編集画面へ遷移 | E-01（行17） | ○ |
| C-06 | secondAdmin.bIntranetContacts権限チェック | E-01（行4） | ○ |
| C-07 | MoveUP処理でiRang-1 | E-02（行142-143） | ○ |
| C-08 | MoveDOWN処理でiRang+1 | E-02（行152-153） | ○ |
| C-09 | 最上位では上移動をスキップ | E-02（行139-141） | ○ |
| C-10 | 最下位では下移動をスキップ | E-02（行149-151） | ○ |
| C-11 | CSRF対策 | E-01（行8,11） | ○ |
| C-12 | sortableクラスでテーブル表示 | E-01（行17） | ○ |
| C-13 | isMandatoryプロパティでYes/No表示 | E-02（行116-122） | ○ |
| C-14 | isSearchFieldプロパティでYes/No表示 | E-02（行123-129） | ○ |
| C-15 | isProfileFieldプロパティでYes/No表示 | E-02（行130-136） | ○ |
| C-16 | customer.contactFields()で一覧取得 | E-01（行16-17） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 並び順変更が正しく動作することを確認
- [ ] フィールド定義が0件の場合の表示を確認
- [ ] CSRF対策が正しく動作することを確認
