---
generated_at: 2026-01-23 22:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：56-連絡先ページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **getPRMenu関数の詳細**：menu.aspの詳細実装を確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_contactPage.asp` 行1-31
- E-02: `asp/includes/contact.asp` 行338-437
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行57
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行85

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 会員に対してページ単位の編集権限を付与 | E-01（行28-29）, E-02（行383-426） | ○ |
| C-02 | タイトル編集/本文編集/リストページ編集の3種類の権限 | E-02（行389-421） | ○ |
| C-03 | secondAdmin.bIntranetContacts権限チェック | E-01（行4） | ○ |
| C-04 | ポップアップで表示 | E-01（行29-30） | ○ |
| C-05 | 通常サイトとイントラネットで別々に権限設定 | E-01（行28-29） | ○ |
| C-06 | 保存前に既存権限を全削除 | E-02（行386-387） | ○ |
| C-07 | fb_saveOKメッセージを表示 | E-01（行15-16） | ○ |
| C-08 | CSRF対策 | E-01（行13） | ○ |
| C-09 | userfilesフォルダを作成 | E-02（行422,427-437） | ○ |
| C-10 | getTPer/getBPer/getLPerで現在の権限取得 | E-01（行23-26）, E-02（行338-382） | ○ |
| C-11 | tblContactPageテーブルを使用 | E-02（行386,391,401,414） | ○ |
| C-12 | lossePaginasでフリーページ取得 | E-01（行20-22） | ○ |
| C-13 | getPRMenuでページツリー生成 | E-01（行28-29） | ○ |
| C-14 | ニックネーム・メールアドレスを表示 | E-01（行28） | ○ |
| C-15 | getPRMenuの詳細実装（チェックボックス生成） | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- getPRMenu関数の詳細実装（menu.asp内）
  - 候補：menu.asp / showMenu.asp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] 権限保存が正しく動作することを確認
- [ ] ページツリー表示が正しく生成されることを確認
- [ ] userfilesフォルダ作成が正常に動作することを確認
- [ ] 通常サイト/イントラネットの権限が独立して管理されることを確認
