---
generated_at: 2026-01-23 22:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：57-一括操作

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_contactSelectionActions.asp` 行1-50
- E-02: `asp/bs_massMailing2.asp` 行1-82
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行58
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行86

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 選択された複数の会員に一括メール送信 | E-01（行27,34-35）, E-02（行20-64） | ○ |
| C-02 | プレースホルダーで会員情報を埋め込み | E-02（行28-41） | ○ |
| C-03 | 過去のメールを再利用（テンプレート選択） | E-01（行9-16,35-39） | ○ |
| C-04 | 件名・本文・背景色の入力 | E-01（行35-40） | ○ |
| C-05 | CC送信先の指定 | E-01（行40）, E-02（行48-56） | ○ |
| C-06 | secondAdmin.bIntranetContacts権限チェック | E-01（行4） | ○ |
| C-07 | CSRF対策 | E-01（行34） | ○ |
| C-08 | 件名・本文の必須バリデーション | E-01（行25-30） | ○ |
| C-09 | 送信履歴をtblMailに保存 | E-02（行66-69） | ○ |
| C-10 | 送信先をtblMailContactに保存 | E-02（行71-79） | ○ |
| C-11 | 重複送信防止（contactDict） | E-02（行8,24,45） | ○ |
| C-12 | server.ScriptTimeout=10000 | E-02（行6） | ○ |
| C-13 | 送信完了後bs_massMailingFB.aspへリダイレクト | E-02（行80） | ○ |
| C-14 | プレースホルダー一覧表示 | E-01（行39-41） | ○ |
| C-15 | チェックボックスタイプはプレースホルダー対象外 | E-01（行40） | ○ |
| C-16 | 日付フィールドはconvertDateToPickerで変換 | E-02（行35-36） | ○ |
| C-17 | CCはカンマ区切りで複数指定可能 | E-02（行16,48-56） | ○ |
| C-18 | メール送信エラー時はErrorReportで記録 | E-02（行58） | ○ |
| C-19 | リッチテキストエディタ使用 | E-01（行40） | ○ |
| C-20 | massHidden関数で選択IDをhidden保持 | E-01（行43-49） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり
- 1: 中リスク - 大量メール送信時のパフォーマンスと配信レート制限の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] プレースホルダー置換が正しく動作することを確認
- [ ] 重複送信防止が正常に機能することを確認
- [ ] CC送信が正しく動作することを確認
- [ ] メール送信エラー時のログ記録を確認
- [ ] 大量メール送信時のタイムアウト設定が適切か確認
