---
generated_at: 2026-01-23 22:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-チケット管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_tickets.asp` 行1-25
- E-02: `asp/includes/ticket.asp` 行1-119
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行59
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行87

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクティベーションチケットの一覧表示 | E-01（行22-24） | ○ |
| C-02 | 登録日時、メール、訪問者詳細を表示 | E-01（行24） | ○ |
| C-03 | アクティベーションリンクの再送信機能 | E-01（行14-21）, E-02（行107-115） | ○ |
| C-04 | チケットの削除機能（単一/複数） | E-01（行5-13）, E-02（行100-106） | ○ |
| C-05 | secondAdmin.bIntranetContacts権限チェック | E-01（行4） | ○ |
| C-06 | CSRF対策 | E-01（行5,15） | ○ |
| C-07 | fb_activationlinkresendメッセージ表示 | E-01（行20） | ○ |
| C-08 | tblContactRegistrationテーブル使用 | E-02（行15-16,82-84,103） | ○ |
| C-09 | sTicketはランダム生成 | E-02（行88） | ○ |
| C-10 | アクティベーションURL形式 | E-02（行116-118） | ○ |
| C-11 | customer.ticketsで一覧取得 | E-01（行22） | ○ |
| C-12 | splitby関数で折り返し表示 | E-01（行24） | ○ |
| C-13 | sortableクラスでテーブル表示 | E-01（行23） | ○ |
| C-14 | 再送信後同じ画面にリダイレクト | E-01（行20） | ○ |
| C-15 | チケット0件時noresultsメッセージ | E-01（行24） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 再送信機能が正しく動作することを確認
- [ ] 複数選択削除が正常に動作することを確認
- [ ] アクティベーションリンクのURL形式が正しいことを確認
- [ ] sVisitorDetailsの内容が適切に表示されることを確認
