---
generated_at: 2026-01-23 22:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-ゲストブック一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_gbList.asp` 行1-11
- E-02: `asp/includes/guestbook.asp` 行1-312
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行60
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行88-89

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ゲストブック一覧を表示 | E-01（行8-10） | ○ |
| C-02 | ゲストブック名をリンクで表示 | E-01（行10） | ○ |
| C-03 | 新規ゲストブック作成画面への遷移 | E-01（行9） | ○ |
| C-04 | ゲストブックの複製機能 | E-01（行5-7）, E-02（行152-158） | ○ |
| C-05 | エントリー管理画面への遷移 | E-01（行10） | ○ |
| C-06 | Excel出力機能 | E-01（行10） | ○ |
| C-07 | 埋め込みコード表示 | E-01（行10） | ○ |
| C-08 | secondAdmin.bGuestbook権限チェック | E-01（行4） | ○ |
| C-09 | 埋め込みコード形式[QS_GUESTBOOK:{sCode}] | E-01（行10）, E-02（行24-29） | ○ |
| C-10 | 複製時に新しいsCodeを生成 | E-02（行155-156） | ○ |
| C-11 | customer.guestbooksで一覧取得 | E-01（行8-9） | ○ |
| C-12 | ゲストブック0件時noguestbooksメッセージ | E-01（行10） | ○ |
| C-13 | 複製後に編集画面へリダイレクト | E-01（行7） | ○ |
| C-14 | Excel出力は新しいウィンドウで開く | E-01（行10） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 複製機能が正しく動作することを確認
- [ ] 埋め込みコードの形式が正しいことを確認
- [ ] Excel出力が正常に動作することを確認
- [ ] エントリー管理画面への遷移が正しく動作することを確認
