---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：6-管理者ダッシュボード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **customerList.aspの詳細実装**：getAll関数の実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_default.asp` 行1-56
- E-02: `asp/ad_security.asp` 行1-3
- E-03: `asp/includes/customer.asp` 行570-684
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 行7
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行13-14
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` 行217-265

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは asp/ad_default.asp である | E-04 | ○ |
| C-02 | Admin認証成功後に自動遷移 | E-06 行33 | ○ |
| C-03 | ad_security.aspで認証チェック | E-01 行4, E-02 | ○ |
| C-04 | showDetailパラメータで表示モード切替 | E-01 行13 | ○ |
| C-05 | iDeleteIDで削除対象を指定 | E-01 行5 | ○ |
| C-06 | cls_customerList.getAllで一覧取得 | E-01 行17 | ○ |
| C-07 | iFolderSizeでディスク使用量表示 | E-01 行19 | ○ |
| C-08 | 自サイト（cId）は削除チェックボックス非表示 | E-01 行28-31 | ○ |
| C-09 | sortableクラスでテーブルソート | E-01 行17, 40 | ○ |
| C-10 | delCust.pick()で顧客データ取得 | E-01 行7 | ○ |
| C-11 | delCust.remove()で削除実行 | E-01 行8 | ○ |
| C-12 | remove()でtblMonitor削除 | E-03 行573 | ○ |
| C-13 | remove()でtblPage削除 | E-03 行574 | ○ |
| C-14 | remove()でtblCustomer削除 | E-03 行575 | ○ |
| C-15 | reset()で関連データクリア | E-03 行572 | ○ |
| C-16 | 統計モードでiTotalHits表示 | E-01 行49 | ○ |
| C-17 | 統計モードでiMaxVisits表示 | E-01 行49 | ○ |
| C-18 | aantalDagenで日数計算 | E-01 行44, E-03 行727-729 | ○ |
| C-19 | 削除確認のconfirmダイアログ | E-01 行35 | ○ |
| C-20 | ad_customer.aspへサイト名リンク | E-01 行25 | ○ |
| C-21 | getBacksiteURL関数でバックサイトURL生成 | E-01 行27 | ○ |
| C-22 | 顧客0件時はad_customer.aspへリダイレクト | E-01 行52 | ○ |
| C-23 | newAccountパラメータで作成完了アラート | E-01 行54-55 | ○ |
| C-24 | JavaScript動的にサイト総数表示 | E-01 行35 | ○ |
| C-25 | JavaScript動的にディスク使用量表示 | E-01 行35 | ○ |
| C-26 | 機能No.8「ページ一覧」に対応 | E-05 | ○ |
| C-27 | 機能No.91「アクセス統計表示」に対応 | E-05 | ○ |
| C-28 | customerList.aspのgetAll関数詳細 | **未詳細確認** | △ |

## 4) 不足情報（Unknown / Missing）
- customerList.aspのgetAll関数の詳細実装
  - 候補：`asp/includes/customerList.asp` / SQLクエリ / ソート順

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成、表示モード、基本フローは実装と一致
- 0: 低リスク - 削除処理のロジックは確認済み
- 0: 低リスク - 自サイト削除防止ロジックが実装されている
- 1: 中リスク - カスケード削除の完全性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ad_default.aspの画面構成が設計書と一致しているか確認
- [ ] 削除処理の動作を確認
- [ ] 統計モードの表示を確認
- [ ] 自サイト削除防止が機能しているか確認
- [ ] customer.remove()のカスケード削除を確認
- [ ] customerList.getAll()の取得データを確認
