---
generated_at: 2026-01-23 22:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-ゲストブック編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_gbEdit.asp` 行1-38
- E-02: `asp/includes/guestbook.asp` 行1-312
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行61
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行90

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ゲストブックの新規作成・編集・削除 | E-01（行11-21） | ○ |
| C-02 | ゲストブック名の入力 | E-01（行22） | ○ |
| C-03 | 公開期間（開始日・終了日）の設定 | E-01（行22） | ○ |
| C-04 | 埋め込みコードの設定 | E-01（行22） | ○ |
| C-05 | 各種テンプレートの編集 | E-01（行22-25） | ○ |
| C-06 | 表示順序の設定 | E-01（行23-25） | ○ |
| C-07 | ページング件数の設定 | E-01（行25） | ○ |
| C-08 | 投稿承認設定 | E-01（行25） | ○ |
| C-09 | 通知メールアドレスの設定 | E-01（行25） | ○ |
| C-10 | ブロックIPの設定 | E-01（行25） | ○ |
| C-11 | ゲストブック名の必須バリデーション | E-02（行78-82） | ○ |
| C-12 | sCodeの必須バリデーション | E-02（行73-77） | ○ |
| C-13 | 削除時に全投稿も削除 | E-02（行146-147） | ○ |
| C-14 | secondAdmin.bGuestbook権限チェック | E-01（行4） | ○ |
| C-15 | CSRF対策 | E-01（行13,19） | ○ |
| C-16 | 保存後にゲストブック一覧にリダイレクト | E-01（行16） | ○ |
| C-17 | 削除後にゲストブック一覧にリダイレクト | E-01（行21） | ○ |
| C-18 | sCodeは大文字に変換 | E-02（行101,127） | ○ |
| C-19 | デフォルトテンプレートの設定 | E-02（行19-31） | ○ |
| C-20 | テンプレートプレースホルダー | E-02（行24-31, 159-214） | ○ |
| C-21 | fullSearchで使用箇所検索 | E-01（行27-36） | ○ |
| C-22 | JQDatePickerで日付選択 | E-01（行22） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] テンプレートプレースホルダーが正しく機能することを確認
- [ ] 公開期間外の場合にフォームが非表示になることを確認
- [ ] 削除時に関連投稿が漏れなく削除されることを確認
- [ ] ブロックIP機能が正しく動作することを確認
- [ ] 承認フローが正しく動作することを確認
