---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：61-エントリー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **メッセージ仕様のfb_saveOK内容**：実際のメッセージ文言はラベルファイル参照が必要
  2. **最大文字数50文字の根拠**：コード内のmaxlength属性から推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_gbEditItems.asp` - メイン画面ファイル
- E-02: `asp/includes/guestbook.asp` - cls_guestbookクラス定義
- E-03: `asp/includes/guestbookitem.asp` - cls_guestbookitemクラス定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_gbEditItems.asp | E-01, E-05 | ○ |
| C-02 | secondAdmin.bGuestbook権限が必要 | E-01 行4 `logon.hasaccess secondAdmin.bGuestbook` | ○ |
| C-03 | URLパラメータはiGBID | E-01 行29 `encrypt(guestbook.iID)` | ○ |
| C-04 | postBackフラグでフォーム送信判定 | E-01 行7-8 | ○ |
| C-05 | CSRF検証はcheckCSRF関数 | E-01 行9 | ○ |
| C-06 | 削除はentry.remove()で実行 | E-01 行18-19 | ○ |
| C-07 | 更新はentry.save()で実行 | E-01 行21 | ○ |
| C-08 | 成功メッセージはfb_saveOK | E-01 行26 | ○ |
| C-09 | 戻り先はbs_gbList.asp | E-01 行29 | ○ |
| C-10 | 投稿者名の最大長は50文字 | E-01 行30 `maxlength="50"` | ○ |
| C-11 | エントリー表示順は作成日時降順 | E-02 行288 `order by dCreatedTS desc` | ○ |
| C-12 | tblGuestBookItemテーブルを使用 | E-02, E-03 | ○ |
| C-13 | sValueはメッセージ本文 | E-03 行3 `Public sValue` | ○ |
| C-14 | sMessageByは投稿者名 | E-03 行4 `Public sMessageBy` | ○ |
| C-15 | sReplyは管理者返信 | E-03 行12 `Public sReply` | ○ |
| C-16 | bApprovedは承認フラグ | E-03 行8 `Public bApproved` | ○ |
| C-17 | ipはIPアドレス | E-03 行11 `Public ip` | ○ |
| C-18 | sMessageByEmailはメールアドレス | E-03 行5 `Public sMessageByEmail` | ○ |
| C-19 | 関連機能No.63はゲストブック投稿管理 | E-04 行91 | ○ |
| C-20 | カテゴリはゲストブック管理 | E-05 行62 | ○ |
| C-21 | 画面遷移はGB_LIST -> GB_EDIT構造 | E-06 行114-115 | ○ |
| C-22 | entriesメソッドはDictionary返却 | E-02 行286 `set entries=server.CreateObject("scripting.dictionary")` | ○ |
| C-23 | QS_VBScriptIdentifierで区切り | E-02 行298 | ○ |
| C-24 | 新規/更新判定はisLeeg(iId) | E-03 行96-99 | ○ |
| C-25 | 削除はDELETE文で実行 | E-03 行142 | ○ |
| C-26 | ページキャッシュクリアが実行される | E-03 行137 `selectedPage.clearPageCache()` | ○ |
| C-27 | メッセージ「保存が完了しました」の具体文言 | **根拠なし** | △ |
| C-28 | テーブル4列はrows="4"から推測 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メッセージラベルの実際の文言定義ファイル
  - 候補：`asp/includes/labels.asp` / 言語ファイル / データベーステーブル
- 画面レイアウトの詳細（CSSクラス定義）
  - 候補：テンプレートCSS / art-button定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造の記述は正確
- 0: 低リスク - 処理フローはコードから直接確認
- 1: 中リスク - メッセージ文言は多言語対応のため実際の表示は確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] secondAdmin.bGuestbook権限の実際の挙動を確認
- [ ] fb_saveOKメッセージの実際の表示文言を確認
- [ ] 削除と更新の同時指定時の優先順位をテスト確認
- [ ] IPアドレス表示のセキュリティ考慮を確認
