---
generated_at: 2026-01-23 10:34:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：63-投票一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **customer.pollsの実装詳細**：投票一覧取得のSQL/ソート順

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_pollList.asp` - メイン画面ファイル
- E-02: `asp/includes/poll.asp` - cls_pollクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_pollList.asp | E-01, E-04 | ○ |
| C-02 | secondAdmin.bPoll権限が必要 | E-01 行4 `logon.hasaccess secondAdmin.bPoll` | ○ |
| C-03 | 複製処理でcls_poll.copy()を使用 | E-01 行5-7 | ○ |
| C-04 | copy()後にbs_pollEdit.aspへリダイレクト | E-01 行7 | ○ |
| C-05 | 投票一覧はcustomer.pollsで取得 | E-01 行9 | ○ |
| C-06 | 新規作成リンクはbs_pollEdit.asp | E-01 行9 `getArtLink("bs_pollEdit.asp"...)` | ○ |
| C-07 | 投票編集リンクはiPollIDパラメータ付き | E-01 行10 `bs_pollEdit.asp?iPollID=` | ○ |
| C-08 | 複製時に確認ダイアログ表示 | E-01 行10 `confirm('areyousuretocopy')` | ○ |
| C-09 | 埋め込みコードはthis.select()で選択可能 | E-01 行10 `onclick="javascript:this.select();"` | ○ |
| C-10 | 埋め込みコード形式は[QS_POLL:code] | E-01 行10 | ○ |
| C-11 | sCodeが空の場合は埋め込みコード非表示 | E-01 行10 `if not isLeeg(polls(pollkey).sCode)` | ○ |
| C-12 | 投票0件時はnopollメッセージ | E-01 行10 | ○ |
| C-13 | 内部IDはiID: xxx形式で表示 | E-01 行10 `<i>iID: <%=pollkey%></i>` | ○ |
| C-14 | copy()はiId=nullにして新規扱い | E-02 行383 | ○ |
| C-15 | copy()でsCode=GeneratePassword | E-02 行384 | ○ |
| C-16 | copy()でsave()呼び出し | E-02 行385 | ○ |
| C-17 | カテゴリは投票管理 | E-04 行64 | ○ |
| C-18 | 関連機能No.59は投票一覧 | E-03 行93 | ○ |
| C-19 | 関連機能No.60は投票作成・編集 | E-03 行94-95 | ○ |
| C-20 | 画面遷移はPOLL_LIST -> POLL_EDIT | E-05 行115-116 | ○ |
| C-21 | 投票最大12個の選択肢 | E-02 行28-61（12個のQuestions.Add） | ○ |
| C-22 | customer.pollsのSQL詳細 | **根拠なし（customerクラス内） ** | △ |

## 4) 不足情報（Unknown / Missing）
- customer.pollsプロパティの実装詳細
  - 候補：`asp/includes/customer.asp` / 顧客クラス定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面遷移・操作は明確
- 0: 低リスク - 複製処理の流れはcls_pollで確認可能
- 1: 中リスク - 投票一覧の取得順序（ソート）は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] customer.pollsの実装を確認し、取得順序を把握
- [ ] GeneratePassword関数の一意性保証を確認
- [ ] 複製時のQS_secCodeURL検証動作を確認
