---
generated_at: 2026-01-23 10:36:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：64-投票編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：31 / 32、根拠なし：1
- 優先レビュー（高）
  1. **bs_pollBack.aspの内容**：インクルードファイルの詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_pollEdit.asp` - メイン画面ファイル
- E-02: `asp/includes/poll.asp` - cls_pollクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_pollEdit.asp | E-01, E-04 | ○ |
| C-02 | secondAdmin.bPoll権限が必要 | E-01 行4 `logon.hasaccess secondAdmin.bPoll` | ○ |
| C-03 | sQuestionは必須項目 | E-02 行138-140 | ○ |
| C-04 | sCodeは必須項目 | E-02 行142-144 | ○ |
| C-05 | 最大12個の選択肢 | E-01 行29 `for ip=1 to 12` | ○ |
| C-06 | 保存時checkCSRF()呼び出し | E-01 行14 | ○ |
| C-07 | 削除時checkCSRF()呼び出し | E-01 行20 | ○ |
| C-08 | リセット時checkCSRF()呼び出し | E-01 行24 | ○ |
| C-09 | 保存後bs_pollList.aspへリダイレクト | E-01 行17 | ○ |
| C-10 | 削除後bs_pollList.aspへリダイレクト | E-01 行22 | ○ |
| C-11 | リセット後bs_pollList.aspへリダイレクト | E-01 行26 | ○ |
| C-12 | JQDatePickerを使用 | E-01 行27-28 | ○ |
| C-13 | JQColorPickerを使用 | E-01 行30-31 | ○ |
| C-14 | 使用箇所検索にcls_fullSearchを使用 | E-01 行34 | ○ |
| C-15 | 検索パターンは正規表現 | E-01 行35 `\[QS_POLL:+(code)+[\]]` | ○ |
| C-16 | 削除時にtblPollVoteも削除 | E-02 行190 | ○ |
| C-17 | remove()でtblPoll削除 | E-02 行192 | ○ |
| C-18 | reset()でtblPollVote削除 | E-02 行199 | ○ |
| C-19 | reset()でdResetDate更新 | E-02 行201-202 | ○ |
| C-20 | showresults()で結果表示 | E-02 行336-380 | ○ |
| C-21 | 投票数はtblPollVoteからCOUNT | E-02 行345 | ○ |
| C-22 | 結果はパーセント表示 | E-02 行361 | ○ |
| C-23 | グラフは色付きdivで表示 | E-02 行368 | ○ |
| C-24 | canVoteでリセット後の再投票判定 | E-02 行278-283 | ○ |
| C-25 | デフォルト色は12色設定 | E-02 行26-61 | ○ |
| C-26 | label_viewresultsデフォルト値 | E-02 行22 | ○ |
| C-27 | label_votenowデフォルト値 | E-02 行23 | ○ |
| C-28 | label_numberofvotesデフォルト値 | E-02 行24 | ○ |
| C-29 | 関連機能No.60は投票作成・編集 | E-03 行95 | ○ |
| C-30 | 新規/更新判定はisLeeg(iId) | E-02 行158 | ○ |
| C-31 | 確認ダイアログはareyousure | E-01 行29 | ○ |
| C-32 | bs_pollBack.aspの詳細内容 | **根拠なし（未読）** | △ |

## 4) 不足情報（Unknown / Missing）
- bs_pollBack.aspファイルの内容
  - 候補：ナビゲーション / 共通UIコンポーネント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な保存・削除・リセット処理は明確
- 0: 低リスク - 入力検証ロジックはcls_pollで確認可能
- 0: 低リスク - 投票結果表示のロジックは詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] bs_pollBack.aspの内容を確認
- [ ] JQDatePicker/JQColorPickerの動作確認
- [ ] cls_fullSearchの検索精度を確認
- [ ] dResetDateによる再投票判定の動作テスト
