---
generated_at: 2026-01-23 10:38:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：65-ポップアップ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **customer.popupsの実装詳細**：ポップアップ一覧取得のSQL/ソート順

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_popupList.asp` - メイン画面ファイル
- E-02: `asp/includes/popup.asp` - cls_popupクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_popupList.asp | E-01, E-04 | ○ |
| C-02 | secondAdmin.bPopup権限が必要 | E-01 行4 `logon.hasaccess secondAdmin.bPopup` | ○ |
| C-03 | 複製処理でcls_popup.copy()を使用 | E-01 行5-7 | ○ |
| C-04 | copy()後にbs_popupEdit.aspへリダイレクト | E-01 行7 | ○ |
| C-05 | リセット処理でiShows=0設定 | E-01 行10-11 | ○ |
| C-06 | リセット後にsave()呼び出し | E-01 行11 | ○ |
| C-07 | ポップアップ一覧はcustomer.popupsで取得 | E-01 行14 | ○ |
| C-08 | 新規作成リンクはbs_popupEdit.asp | E-01 行15 `getArtLink("bs_popupEdit.asp"...)` | ○ |
| C-09 | 編集リンクはipopupIDパラメータ付き | E-01 行16 `bs_popupEdit.asp?ipopupID=` | ○ |
| C-10 | 表示回数は"X times shown"形式 | E-01 行16 | ○ |
| C-11 | 有効時はEnabled（太字）表示 | E-01 行16 `<strong>Enabled</strong>` | ○ |
| C-12 | 無効時はDisabled（グレー斜体）表示 | E-01 行16 `<i><font color=#AAA>Disabled</font></i>` | ○ |
| C-13 | プレビューはwindow.open()で表示 | E-01 行16 | ○ |
| C-14 | プレビューURLにforcePPパラメータ | E-01 行16 `forcePP=` | ○ |
| C-15 | 複製時に確認ダイアログ表示 | E-01 行16 `confirm('areyousuretocopy')` | ○ |
| C-16 | 0件時は"No Popups available"表示 | E-01 行16 | ○ |
| C-17 | copy()はiId=nullにして新規扱い | E-02 行189 | ○ |
| C-18 | copy()でsave()呼び出し | E-02 行190 | ○ |
| C-19 | bEnabledは有効/無効フラグ | E-02 行3 | ○ |
| C-20 | iShowsは表示回数 | E-02 行3 | ○ |
| C-21 | iModeは表示頻度制御 | E-02 行40-86（bOnlineプロパティ内） | ○ |
| C-22 | カテゴリはポップアップ管理 | E-04 行66 | ○ |
| C-23 | 関連機能No.65はポップアップ一覧 | E-03 行96 | ○ |
| C-24 | customer.popupsのSQL詳細 | **根拠なし（customerクラス内）** | △ |

## 4) 不足情報（Unknown / Missing）
- customer.popupsプロパティの実装詳細
  - 候補：`asp/includes/customer.asp` / 顧客クラス定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面遷移・操作は明確
- 0: 低リスク - 複製・リセット処理の流れはcls_popupで確認可能
- 1: 中リスク - 一覧の取得順序（ソート）は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] customer.popupsの実装を確認し、取得順序を把握
- [ ] forcePPパラメータによるプレビュー動作を確認
- [ ] iModeによる表示制御（Cookie/セッション）の動作確認
