---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：66-ポップアップ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **bs_popupBack.aspの内容**：インクルードファイルの詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_popupEdit.asp` - メイン画面ファイル
- E-02: `asp/includes/popup.asp` - cls_popupクラス定義
- E-03: `asp/includes/popupModeList.asp` - 表示モード選択肢定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_popupEdit.asp | E-01, E-05 | ○ |
| C-02 | bNOPopup=trueが設定される | E-01 行4 | ○ |
| C-03 | secondAdmin.bPopup権限が必要 | E-01 行4 `logon.hasaccess secondAdmin.bpopup` | ○ |
| C-04 | cls_popupModeListを使用 | E-01 行5 | ○ |
| C-05 | 削除処理でpopup.remove()呼び出し | E-01 行10 | ○ |
| C-06 | 削除後bs_popupList.aspへリダイレクト | E-01 行11 | ○ |
| C-07 | 保存時checkCSRF()呼び出し | E-01 行15 | ○ |
| C-08 | 保存後bs_popupList.aspへリダイレクト | E-01 行17 | ○ |
| C-09 | sNameの最大長は50文字 | E-01 行19 `maxlength=50` | ○ |
| C-10 | sUrlの最大長は255文字 | E-01 行19 `maxlength=255` | ○ |
| C-11 | createFCKInstanceでエディタ生成 | E-01 行19 | ○ |
| C-12 | iWidth/iHeightは10〜1000の選択 | E-01 行20 `numberList(10,1000,1,...)` | ○ |
| C-13 | iAutocloseは0〜120の選択 | E-01 行20 `numberList(0,120,1,...)` | ○ |
| C-14 | JQDatePickerを使用 | E-01 行19-20 | ○ |
| C-15 | 削除時に確認ダイアログ | E-01 行21 `confirm('areyousure')` | ○ |
| C-16 | check()でsName必須チェック | E-02 行135-138 | ○ |
| C-17 | check()でsUrl/sValue少なくとも一方必須 | E-02 行139-142 | ○ |
| C-18 | 新規/更新判定はisLeeg(iId) | E-02 行155 | ○ |
| C-19 | remove()でDELETE実行 | E-02 行183 | ○ |
| C-20 | iModeのデフォルト値は0 | E-02 行14 | ○ |
| C-21 | iWidthのデフォルト値は400 | E-02 行12 | ○ |
| C-22 | iHeightのデフォルト値は300 | E-02 行11 | ○ |
| C-23 | 表示モード0は"Show once/visit" | E-03 行6 | ○ |
| C-24 | 表示モード1は"Show once/visitor" | E-03 行7 | ○ |
| C-25 | 表示モード3-10はN回目のページロード | E-03 行8-15 | ○ |
| C-26 | カテゴリはポップアップ管理 | E-05 行67 | ○ |
| C-27 | 関連機能No.66はポップアップ作成・編集 | E-04 行98 | ○ |
| C-28 | bs_popupBack.aspの詳細内容 | **根拠なし（未読）** | △ |

## 4) 不足情報（Unknown / Missing）
- bs_popupBack.aspファイルの内容
  - 候補：ナビゲーション / 共通UIコンポーネント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な保存・削除処理は明確
- 0: 低リスク - 入力検証ロジックはcls_popupで確認可能
- 0: 低リスク - 表示モード選択肢はcls_popupModeListで定義済み

## 6) レビュアーチェックリスト（最小）
- [ ] bs_popupBack.aspの内容を確認
- [ ] createFCKInstance関数の動作確認
- [ ] 表示モード2が未定義の理由を確認（3から開始）
- [ ] URLとテキスト両方設定時の動作確認
