---
generated_at: 2026-01-23 10:42:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：67-ポップアップモード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **tblCustomerのsPopupViewmodeカラム**：データベーススキーマの確認
  2. **Colorboxスタイルとの対応**：実際のスタイル適用の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_popupMode.asp` - メイン画面ファイル
- E-02: `asp/includes/popup.asp` - cls_popupクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_popupMode.asp | E-01, E-04 | ○ |
| C-02 | secondAdmin.bTemplates権限チェックがコメントアウト | E-01 行4 `'logon.hasaccess secondAdmin.bTemplates` | ○ |
| C-03 | getBOHeaderがコメントアウト | E-01 行4 `'=getBOHeader(btn_Setup)` | ○ |
| C-04 | sPopupViewmodeをPOSTで受信 | E-01 行4 `request.form("sPopupViewmode")` | ○ |
| C-05 | customer.sPopupViewmodeに設定 | E-01 行5 | ○ |
| C-06 | customer.save()で保存 | E-01 行6 | ○ |
| C-07 | リダイレクト先にfbMessage=fb_saveOK | E-01 行7 | ○ |
| C-08 | 5種類のラジオボタン（値1〜5） | E-01 行8 | ○ |
| C-09 | エフェクト1はDark Rounded Square | E-01 行8 | ○ |
| C-10 | エフェクト2はLight Square | E-01 行8 | ○ |
| C-11 | エフェクト3はDark Square | E-01 行8 | ○ |
| C-12 | エフェクト4はLight Rounded Square | E-01 行8 | ○ |
| C-13 | エフェクト5はGray Square | E-01 行8 | ○ |
| C-14 | 現在の値でchecked='checked'設定 | E-01 行8 | ○ |
| C-15 | sGetViewmodeプロパティで取得 | E-02 行22-27 | ○ |
| C-16 | カテゴリはポップアップ管理 | E-04 行68 | ○ |
| C-17 | tblCustomerにsPopupViewmodeカラム存在 | **根拠なし（DBスキーマ未確認）** | △ |
| C-18 | Colorboxスタイルとの対応関係 | **根拠なし（CSS/JS未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- tblCustomerのテーブル定義
  - 候補：データベーススキーマ定義 / CREATE TABLE文
- Colorboxのスタイル設定ファイル
  - 候補：CSS / JavaScript / colorbox設定

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 権限チェックがコメントアウトされているセキュリティ考慮
- 0: 低リスク - 基本的な保存処理フローは明確
- 1: 中リスク - 実際のスタイル適用（フロントエンド）は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] 権限チェックのコメントアウトが意図的かどうか確認
- [ ] tblCustomerにsPopupViewmodeカラムが存在することを確認
- [ ] Colorboxスタイル（1〜5）の実際の見た目を確認
- [ ] フロントエンドでのスタイル適用処理を確認
