---
generated_at: 2026-01-23 10:44:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：68-フィード一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **customer.feedsの実装詳細**：フィード一覧取得のSQL/ソート順

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_feedList.asp` - メイン画面ファイル
- E-02: `asp/includes/feed.asp` - cls_feedクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_feedList.asp | E-01, E-04 | ○ |
| C-02 | secondAdmin.bFeed権限が必要 | E-01 行4 `logon.hasaccess secondAdmin.bFeed` | ○ |
| C-03 | 複製処理でcls_feed.copy()を使用 | E-01 行5-7 | ○ |
| C-04 | copy()後にbs_feedEdit.aspへリダイレクト | E-01 行7 | ○ |
| C-05 | フィード一覧はcustomer.feedsで取得 | E-01 行9 | ○ |
| C-06 | 新規作成リンクはbs_feedEdit.asp | E-01 行9 `getArtLink("bs_feedEdit.asp"...)` | ○ |
| C-07 | フィード編集リンクはifeedIDパラメータ付き | E-01 行10 `bs_feedEdit.asp?ifeedID=` | ○ |
| C-08 | プレビューリンクはbs_feedPreview.asp | E-01 行10 | ○ |
| C-09 | 複製時に確認ダイアログ表示 | E-01 行10 `confirm('areyousuretocopy')` | ○ |
| C-10 | 埋め込みコードはthis.select()で選択可能 | E-01 行10 `onclick="javascript:this.select();"` | ○ |
| C-11 | 埋め込みコード形式は[QS_FEED:code] | E-01 行10 | ○ |
| C-12 | sCodeが空の場合は埋め込みコード非表示 | E-01 行10 `if not isLeeg(feeds(feedkey).sCode)` | ○ |
| C-13 | フィード0件時はnofeedメッセージ | E-01 行10 | ○ |
| C-14 | 内部IDはiID: xxx形式で表示 | E-01 行10 `<i>iID: <%=feedkey%></i>` | ○ |
| C-15 | copy()はiId=nullにして新規扱い | E-02 行195 | ○ |
| C-16 | copy()でsName="Copy of "+sName | E-02 行196 `sName=l("copyof") & " " & sName` | ○ |
| C-17 | copy()でsCode="" | E-02 行197 | ○ |
| C-18 | copy()でsave()呼び出し | E-02 行198 | ○ |
| C-19 | RSS/Atom両形式に対応 | E-02 行285-300（feed type判定） | ○ |
| C-20 | build()でキャッシュ処理 | E-02 行204、450-456 | ○ |
| C-21 | カテゴリはフィード管理 | E-04 行69 | ○ |
| C-22 | 関連機能No.53はフィード一覧 | E-03 行100 | ○ |
| C-23 | 関連機能No.54はフィード作成・編集 | E-03 行101-102 | ○ |
| C-24 | customer.feedsのSQL詳細 | **根拠なし（customerクラス内）** | △ |

## 4) 不足情報（Unknown / Missing）
- customer.feedsプロパティの実装詳細
  - 候補：`asp/includes/customer.asp` / 顧客クラス定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面遷移・操作は明確
- 0: 低リスク - 複製処理の流れはcls_feedで確認可能
- 1: 中リスク - フィード一覧の取得順序（ソート）は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] customer.feedsの実装を確認し、取得順序を把握
- [ ] l("copyof")の実際の文言を確認
- [ ] フィードのキャッシュ時間（iCache）のデフォルト値を確認
