---
generated_at: 2026-01-23 10:46:00
metrics:
  claims_total: 36
  claims_with_evidence: 35
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：69-フィード編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：35 / 36、根拠なし：1
- 優先レビュー（高）
  1. **bs_feedBack.aspの内容**：インクルードファイルの詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_feedEdit.asp` - メイン画面ファイル
- E-02: `asp/includes/feed.asp` - cls_feedクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_feedEdit.asp | E-01, E-04 | ○ |
| C-02 | secondAdmin.bFeed権限が必要 | E-01 行4 `logon.hasaccess secondAdmin.bFeed` | ○ |
| C-03 | sNameは必須項目 | E-02 行67-70 | ○ |
| C-04 | sUrl/sUrlsのどちらか一方必須 | E-02 行71-85 | ○ |
| C-05 | sCode重複チェック | E-02 行86-94 | ○ |
| C-06 | 自己参照URLチェック | E-02 行77-84 | ○ |
| C-07 | 保存時checkCSRF()呼び出し | E-01 行11 | ○ |
| C-08 | 削除時checkCSRF()呼び出し | E-01 行17 | ○ |
| C-09 | 保存後bs_feedList.aspへリダイレクト | E-01 行14 | ○ |
| C-10 | 削除後bs_feedList.aspへリダイレクト | E-01 行19 | ○ |
| C-11 | iMaxItemsは1〜100 | E-01 行22 `numberList(1,100,1,...)` | ○ |
| C-12 | iCacheは0〜14400（30秒刻み） | E-01 行22 `numberList(0,14400,30,...)` | ○ |
| C-13 | iTitleLimitToは0〜100 | E-01 行23 `numberList(0,100,1,...)` | ○ |
| C-14 | iLimitToは0〜2500（5刻み） | E-01 行24 `numberList(0,2500,5,...)` | ○ |
| C-15 | bTemplateチェック時にフォームサブミット | E-01 行22 `onclick="javascript:document.mainform.submit();"` | ○ |
| C-16 | bShowTitleチェック時にフォームサブミット | E-01 行22 | ○ |
| C-17 | 使用箇所検索にcls_fullSearchを使用 | E-01 行28 | ○ |
| C-18 | 検索パターンは正規表現 | E-01 行29 `\[QS_FEED:+(code)+[\]]` | ○ |
| C-19 | sCodeは大文字変換 | E-02 行156 `ucase(...)` | ○ |
| C-20 | 削除時にtblPageのiFeedIDをnull更新 | E-02 行185 | ○ |
| C-21 | remove()でtblFeed削除 | E-02 行187 | ○ |
| C-22 | save()でcustomer.cacheFeeds()呼び出し | E-02 行145 | ○ |
| C-23 | save()でアプリケーションキャッシュクリア | E-02 行146 | ○ |
| C-24 | テンプレート変数{AUTHOR}対応 | E-02 行405 | ○ |
| C-25 | テンプレート変数{TITLE}対応 | E-02 行404 | ○ |
| C-26 | テンプレート変数{DATE}対応 | E-02 行406 | ○ |
| C-27 | テンプレート変数{CATEGORY}対応 | E-02 行407 | ○ |
| C-28 | テンプレート変数{DESCRIPTION}対応 | E-02 行427 | ○ |
| C-29 | テンプレート変数{LINK}対応 | E-02 行392 | ○ |
| C-30 | テンプレート変数{IMAGE}対応 | E-02 行408 | ○ |
| C-31 | テンプレート変数{ENCLOSURE}対応 | E-02 行409 | ○ |
| C-32 | テンプレート変数{COUNTER}対応 | E-02 行410 | ○ |
| C-33 | RSS形式対応 | E-02 行285-292 | ○ |
| C-34 | Atom形式対応 | E-02 行293-300 | ○ |
| C-35 | 関連機能No.54はフィード作成・編集 | E-03 行102 | ○ |
| C-36 | bs_feedBack.aspの詳細内容 | **根拠なし（未読）** | △ |

## 4) 不足情報（Unknown / Missing）
- bs_feedBack.aspファイルの内容
  - 候補：ナビゲーション / 共通UIコンポーネント
- cls_urlTypeShortListの定義
  - 候補：http/https選択肢の定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な保存・削除処理は明確
- 0: 低リスク - 入力検証ロジックはcls_feedで確認可能
- 0: 低リスク - RSS/Atom両形式のパース処理は詳細に実装

## 6) レビュアーチェックリスト（最小）
- [ ] bs_feedBack.aspの内容を確認
- [ ] cls_urlTypeShortListの定義を確認
- [ ] 自己参照URLチェックの動作確認
- [ ] キャッシュ機能の動作確認
