---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-ページ作成画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目で根拠確認済み）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_setupPage.asp` 行1-14
- E-02: `asp/bs_process.asp` 行74-92
- E-03: `asp/bs_security.asp` 行40
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 行8
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行15
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` 行47, 96-99

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは asp/bs_setupPage.asp である | E-04 | ○ |
| C-02 | secondAdmin.bPagesAddで権限チェック | E-01 行4, E-03 | ○ |
| C-03 | logon.hasaccess関数で権限確認 | E-01 行4 | ○ |
| C-04 | cls_fixedTypeListでタイプ一覧取得 | E-01 行5 | ○ |
| C-05 | iParentIDがHiddenで渡される | E-01 行6 | ○ |
| C-06 | btnaction="continue"でPOST | E-01 行6 | ○ |
| C-07 | bIntranetがHiddenで渡される | E-01 行6 | ○ |
| C-08 | 親ページありの場合、タイトル表示 | E-01 行6 | ○ |
| C-09 | 親ページありの場合、sb_lossePagina除外 | E-01 行10 | ○ |
| C-10 | 最初のタイプがデフォルト選択 | E-01 行10（trunner=0） | ○ |
| C-11 | sb_itemでbs_editItem.aspへ遷移 | E-02 行77-78 | ○ |
| C-12 | sb_containerでbs_editContainer.aspへ遷移 | E-02 行79-80 | ○ |
| C-13 | sb_externalURLでbs_editExternalURL.aspへ遷移 | E-02 行81-82 | ○ |
| C-14 | sb_listでbs_editList.aspへ遷移 | E-02 行83-84 | ○ |
| C-15 | sb_lossePaginaでbs_editItem.asp?bLossePagina=trueへ遷移 | E-02 行85-86 | ○ |
| C-16 | sb_constantでbs_constantEdit.aspへ遷移 | E-02 行87-88 | ○ |
| C-17 | 選択なしでerr_makeChoiceエラー | E-02 行89-90 | ○ |
| C-18 | リダイレクト時にパラメータ付与 | E-02 行92 | ○ |
| C-19 | イントラネット時にbs_backIntranet.aspインクルード | E-01 行13 | ○ |
| C-20 | 機能No.9「ページ作成・編集」に対応 | E-05 | ○ |
| C-21 | 画面遷移図と遷移先が一致 | E-06 | ○ |
| C-22 | 多言語対応されている（l関数使用） | E-01 行4, 10-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に対して根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成、タイプ選択、遷移先が実装と一致
- 0: 低リスク - 権限チェックが実装されている
- 0: 低リスク - 全項目で根拠が確認されている

## 6) レビュアーチェックリスト（最小）
- [ ] bs_setupPage.aspの画面構成が設計書と一致しているか確認
- [ ] 権限チェック（hasaccess関数）の動作を確認
- [ ] 各ページタイプの遷移先を確認
- [ ] 親ページありの場合のフリーページ除外を確認
- [ ] イントラネットモードの動作を確認
