---
generated_at: 2026-01-23 10:48:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-フィードプレビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先すべき項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_feedPreview.asp` - メイン画面ファイル
- E-02: `asp/includes/feed.asp` - cls_feedクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_feedPreview.asp | E-01, E-04 | ○ |
| C-02 | secondAdmin.bFeed権限が必要 | E-01 行4 `logon.hasaccess secondAdmin.bFeed` | ○ |
| C-03 | URLパラメータはifeedID | E-01 cls_feedコンストラクタ参照 | ○ |
| C-04 | 戻りリンクはbs_feedList.asp | E-01 行4 | ○ |
| C-05 | プレビュー表示は幅600px | E-01 行4 `width=600` | ○ |
| C-06 | cls_feedオブジェクトを生成 | E-01 行5 `set feed=new cls_feed` | ○ |
| C-07 | feed.build()で表示生成 | E-01 行6 `Response.write feed.build()` | ○ |
| C-08 | feedオブジェクトを解放 | E-01 行7 `set feed=nothing` | ○ |
| C-09 | build()でキャッシュ確認 | E-02 行204 | ○ |
| C-10 | build()でXMLDOM使用 | E-02 行259 | ○ |
| C-11 | build()でRSS判定 | E-02 行285-292 | ○ |
| C-12 | build()でAtom判定 | E-02 行293-300 | ○ |
| C-13 | build()でキャッシュ保存 | E-02 行450-451 | ○ |
| C-14 | エラー時はOn Error Resume Next | E-02 行205 | ○ |
| C-15 | カテゴリはフィード管理 | E-04 行71 | ○ |
| C-16 | 関連機能No.55はフィードプレビュー | E-03 行103 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな画面で処理フローが明確
- 0: 低リスク - 参照専用のため、データ更新のリスクなし
- 1: 中リスク - 外部フィード取得のネットワークエラー処理の確認

## 6) レビュアーチェックリスト（最小）
- [ ] フィード取得エラー時の表示内容を確認
- [ ] キャッシュ有効時と無効時のプレビュー挙動を確認
- [ ] 不正なifeedIDパラメータ時の挙動を確認
