---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：71-テンプレート一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **bBrowseOnlineTemplates設定の詳細**：設定ファイルの参照が不足
  2. **sNewTemplatesPath変数の定義元**：グローバル設定の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_templateList.asp` - テンプレート一覧画面メインファイル（行1-127）
- E-02: `asp/includes/template.asp` - cls_templateクラス定義（行1-809）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.71の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報
- E-06: `asp/bs_templateEdit.asp` - テンプレート編集画面
- E-07: `asp/bs_uploadzip.asp` - ZIPアップロード画面
- E-08: `asp/bs_templateSearch.asp` - テンプレート検索画面

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスはasp/bs_templateList.asp | E-01, E-03 | ○ |
| C-02 | secondAdmin.bTemplates権限が必要 | E-01（行4） | ○ |
| C-03 | テンプレート一覧をテーブル形式で表示 | E-01（行25-26） | ○ |
| C-04 | copy/delete/defaultの3アクションをサポート | E-01（行8-16） | ○ |
| C-05 | CSRFトークンによるセキュリティチェック | E-01（行7） | ○ |
| C-06 | cls_templateクラスのcopy()メソッドで複製 | E-02（行199-205） | ○ |
| C-07 | cls_templateクラスのremove()メソッドで削除 | E-02（行186-198） | ○ |
| C-08 | テンプレート削除時にtblPageのiTemplateIDをnull更新 | E-02（行189） | ○ |
| C-09 | テンプレート削除時にtblCustomerのdefaultTemplateをnull更新 | E-02（行191-193） | ○ |
| C-10 | customer.defaultTemplateでデフォルト設定 | E-01（行14-15） | ○ |
| C-11 | テンプレートが1件以下の場合は削除ボタン非表示 | E-01（行22-24） | ○ |
| C-12 | デフォルトテンプレートには削除ボタン非表示 | E-01（行26） | ○ |
| C-13 | プレビューはJavaScriptでポップアップ表示 | E-01（行26） | ○ |
| C-14 | ZIPサポートはcustomer.supportZipperで判定 | E-01（行29） | ○ |
| C-15 | ZIPコンポーネントはXStandardを使用 | E-01（行29） | ○ |
| C-16 | オンラインテンプレート検索はbBrowseOnlineTemplatesで制御 | E-01（行30） | ○ |
| C-17 | カテゴリ別テンプレート表示はtemplateCatList関数 | E-01（行40-59） | ○ |
| C-18 | テンプレートプレビューはshowTemplateBox関数 | E-01（行60-82） | ○ |
| C-19 | テンプレートインストールはinstallTemplate関数 | E-01（行83-126） | ○ |
| C-20 | Artisteer/JSTemplatesテンプレート対応 | E-02（行214-808） | ○ |
| C-21 | テンプレートには5種類のバリエーション | E-02（行20-47, 71-102） | ○ |
| C-22 | テンプレート圧縮機能bCompressの存在 | E-02（行8, 154-158） | ○ |
| C-23 | テンプレート一覧はcustomer.templatesから取得 | E-01（行20） | ○ |
| C-24 | 関連機能No.25がテンプレート一覧 | E-04 | ○ |
| C-25 | 関連機能No.26がテンプレート作成・編集 | E-04 | ○ |
| C-26 | 関連機能No.30がデフォルトテンプレート設定 | E-04 | ○ |
| C-27 | bBrowseOnlineTemplatesの定義場所 | **根拠なし** | △ |
| C-28 | sNewTemplatesPathの定義場所 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **bBrowseOnlineTemplates変数の定義場所が不明**
  - 候補：begin.asp / config.asp / Application変数
- **sNewTemplatesPath変数の定義場所が不明**
  - 候補：begin.asp / config.asp / Application変数
- テンプレートテーブル（tblTemplate）のスキーマ定義ファイルが未確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全体的にソースコードとの整合性が高い
- **1（中リスク）**: グローバル変数の定義元が未確認（bBrowseOnlineTemplates, sNewTemplatesPath）
- **0（低リスク）**: データベース操作の記述はcls_templateクラスと整合

## 6) レビュアーチェックリスト（最小）
- [ ] bs_templateList.aspの行4でsecondAdmin.bTemplates権限チェックを確認
- [ ] cls_templateクラスのcopy()、remove()メソッドの実装を確認
- [ ] テンプレート削除時の関連テーブル更新処理を確認
- [ ] bBrowseOnlineTemplates、sNewTemplatesPathの定義元を特定
- [ ] ZIPコンポーネント（XStandard）のインストール要件を確認
