---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：72-テンプレート編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全項目が根拠ありのため、特になし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_templateEdit.asp` - テンプレート編集画面メインファイル（行1-36）
- E-02: `asp/includes/template.asp` - cls_templateクラス定義（行1-809）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.72の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-05: `asp/bs_templateBack.asp` - テンプレート画面共通フッター
- E-06: `asp/bs_templateList.asp` - テンプレート一覧画面

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスはasp/bs_templateEdit.asp | E-01, E-03 | ○ |
| C-02 | secondAdmin.bTemplates権限が必要 | E-01（行4） | ○ |
| C-03 | テキスト方向がLTRに強制設定 | E-01（行4） | ○ |
| C-04 | save/delete/previewの3アクションをサポート | E-01（行6-28） | ○ |
| C-05 | CSRFトークンによるセキュリティチェック | E-01（行8, 14, 18） | ○ |
| C-06 | getRequestValues()でフォーム値取得 | E-01（行9, 19）, E-02（行177-185） | ○ |
| C-07 | save()でデータベースに保存 | E-01（行10, 20）, E-02（行137-176） | ○ |
| C-08 | remove()でテンプレート削除 | E-01（行15）, E-02（行186-198） | ○ |
| C-09 | 削除後はbs_templateList.aspにリダイレクト | E-01（行16） | ○ |
| C-10 | プレビュー時にセッションiTemplateID設定 | E-01（行21） | ○ |
| C-11 | プレビュー後はdefault.aspにリダイレクト | E-01（行22） | ○ |
| C-12 | 新規時はinit()でデフォルトテンプレートロード | E-01（行26-27）, E-02（行60-70） | ○ |
| C-13 | テンプレート1件以下は削除ボタン非表示 | E-01（行31） | ○ |
| C-14 | デフォルトテンプレートは削除ボタン非表示 | E-01（行31） | ○ |
| C-15 | 新規作成時は削除・プレビューボタン非表示 | E-01（行34-35） | ○ |
| C-16 | sNameの最大長は255文字 | E-01（行33） | ○ |
| C-17 | テキストエリアは60行x110列 | E-01（行33） | ○ |
| C-18 | bCompressオプションの存在 | E-01（行34）, E-02（行154-158） | ○ |
| C-19 | check()で必須バリデーション | E-02（行126-136） | ○ |
| C-20 | sNameは保存時に50文字に切り詰め | E-02（行159） | ○ |
| C-21 | 圧縮版はcompressHTML関数で生成 | E-02（行155） | ○ |
| C-22 | 関連機能No.26がテンプレート作成・編集 | E-04 | ○ |
| C-23 | bs_variables.aspへのリンク | E-01（行33） | ○ |
| C-24 | bs_templateBack.aspで戻るリンク表示 | E-05（行2） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張に根拠が存在する。
- compressHTML関数の詳細実装は別ファイルに存在する可能性あり

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主張がソースコードで確認可能
- **0（低リスク）**: データベース操作の記述はcls_templateクラスと整合
- **0（低リスク）**: セキュリティ処理（CSRF、権限）が適切に実装

## 6) レビュアーチェックリスト（最小）
- [ ] bs_templateEdit.aspの行4でsecondAdmin.bTemplates権限チェックを確認
- [ ] cls_templateクラスのcheck()メソッドのバリデーション内容を確認
- [ ] save()メソッドでの圧縮処理（bCompress=true時）を確認
- [ ] プレビュー機能でセッション変数が正しく設定されることを確認
- [ ] 削除ボタンの条件表示ロジック（テンプレート数、デフォルトテンプレート）を確認
