---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：73-テンプレート作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **allowedFileTypes変数の定義場所**：ファイルタイプ制限の詳細が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_CreateTemplate.asp` - テンプレート作成画面メインファイル（行1-122）
- E-02: `asp/includes/template.asp` - cls_templateクラス定義（行1-809）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.73の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-05: `asp/bs_unzip.asp` - ZIP解凍画面（遷移元）
- E-06: `asp/bs_templateList.asp` - テンプレート一覧画面（遷移先）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスはasp/bs_CreateTemplate.asp | E-01, E-03 | ○ |
| C-02 | secondAdmin.bTemplates権限が必要 | E-01（行3） | ○ |
| C-03 | pathパラメータでフォルダパスを受け取る | E-01（行14） | ○ |
| C-04 | FileSystemObjectでフォルダ存在確認 | E-01（行15-16） | ○ |
| C-05 | foldernameとfileが必須項目 | E-01（行29-33） | ○ |
| C-06 | cls_templateインスタンスでテンプレート作成 | E-01（行37-38） | ○ |
| C-07 | HTMLファイル読み込みにOpenTextFile使用 | E-01（行41） | ○ |
| C-08 | bConsiderArtisteerでtreatAsArtisteer呼び出し | E-01（行48-54）, E-02（行376-808） | ○ |
| C-09 | initWAP, initPrint, initMobile, initEmail呼び出し | E-01（行56-60） | ○ |
| C-10 | save()でデータベースに保存 | E-01（行62） | ○ |
| C-11 | 保存成功時にbs_templateList.aspへリダイレクト | E-01（行63） | ○ |
| C-12 | page.html/index.htmlが優先選択される | E-01（行83-84, 102-108） | ○ |
| C-13 | .htmファイル存在時にbConsiderArtisteer自動設定 | E-01（行84-91） | ○ |
| C-14 | blog.html/home.htmlは表示対象から除外 | E-01（行93-95） | ○ |
| C-15 | 不許可ファイルタイプは自動削除 | E-01（行96-100） | ○ |
| C-16 | フォルダ不存在時にエラーメッセージ表示 | E-01（行121） | ○ |
| C-17 | ルートにファイルなし時にフォルダ削除 | E-01（行76） | ○ |
| C-18 | bs_unzip.aspから遷移 | E-05（行48） | ○ |
| C-19 | bSetFooterVar等のフラグ設定（JSTemplate時） | E-01（行49-52） | ○ |
| C-20 | treatAsArtisteerでCMS変数への置換 | E-02（行376-808） | ○ |
| C-21 | 関連機能No.26がテンプレート作成・編集 | E-04 | ○ |
| C-22 | allowedFileTypesによるファイルタイプ制限 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **allowedFileTypes変数の定義場所が不明**
  - 候補：begin.asp / config.asp / Application変数
- art_header.txt、template_*.txtファイルの内容は未確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全体的にソースコードとの整合性が高い
- **1（中リスク）**: allowedFileTypes変数の定義元が未確認
- **0（低リスク）**: データベース操作の記述はcls_templateクラスと整合

## 6) レビュアーチェックリスト（最小）
- [ ] bs_CreateTemplate.aspの行3でsecondAdmin.bTemplates権限チェックを確認
- [ ] フォルダパラメータのバリデーション（パストラバーサル対策）を確認
- [ ] treatAsArtisteer()メソッドのテンプレート変換ロジックを確認
- [ ] allowedFileTypes変数の定義元と許可ファイルタイプを特定
- [ ] 不許可ファイル削除処理のセキュリティ影響を確認
