---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：74-テンプレート検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **SaveBinaryData関数の定義場所**：ファイル保存処理の詳細が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_templateSearch.asp` - テンプレート検索画面メインファイル（行1-79）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.74の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-04: `asp/bs_templateList.asp` - テンプレート一覧画面（遷移元）
- E-05: `asp/bs_CreateTemplate.asp` - テンプレート作成画面（遷移先）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスはasp/bs_templateSearch.asp | E-01, E-02 | ○ |
| C-02 | secondAdmin.bTemplates権限が必要 | E-01（行4） | ○ |
| C-03 | 1ページ30件表示（browseBy=30） | E-01（行5） | ○ |
| C-04 | sBrowseOnlineTemplatesUrlをカスタム可能 | E-01（行6-8） | ○ |
| C-05 | installパラメータでダウンロード処理開始 | E-01（行10） | ○ |
| C-06 | MSXML2.ServerXMLHTTPで外部通信 | E-01（行11） | ○ |
| C-07 | ディレクトリ構造を事前作成 | E-01（行22-26） | ○ |
| C-08 | ファイルをループでダウンロード | E-01（行27-35） | ○ |
| C-09 | status=200のファイルのみ保存 | E-01（行31-33） | ○ |
| C-10 | SaveBinaryDataでバイナリ保存 | E-01（行32） | ○ |
| C-11 | インストール後bs_createTemplate.aspへリダイレクト | E-01（行38） | ○ |
| C-12 | テンプレートリストをセッションにキャッシュ | E-01（行40-49） | ○ |
| C-13 | iStart=0の場合は1に設定 | E-01（行51） | ○ |
| C-14 | サムネイル画像は180px幅で表示 | E-01（行59） | ○ |
| C-15 | プレビューはbPopupFullWidthNoReloadクラス | E-01（行59） | ○ |
| C-16 | プレビューはpage.htmlを表示 | E-01（行59） | ○ |
| C-17 | Download & Installに確認ダイアログ | E-01（行60） | ○ |
| C-18 | navbalk関数でページング生成 | E-01（行66-78） | ○ |
| C-19 | 関連機能No.29がオンラインテンプレート検索 | E-03 | ○ |
| C-20 | SaveBinaryData関数の定義場所 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **SaveBinaryData関数の定義場所が不明**
  - 候補：begin.asp / 共通インクルードファイル
- sBrowseOnlineTemplatesUrl変数の初期値定義場所が不明
- 外部サーバーのlist.aspレスポンス形式の詳細仕様

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ソースコードとの整合性が高い
- **1（中リスク）**: SaveBinaryData関数の実装詳細が未確認
- **2（高リスク）**: 外部サーバーからのファイルダウンロードにセキュリティリスクの可能性（入力検証要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] bs_templateSearch.aspの行4でsecondAdmin.bTemplates権限チェックを確認
- [ ] installパラメータの入力検証（パストラバーサル対策）を確認
- [ ] 外部サーバーとの通信がHTTPSであることを確認
- [ ] SaveBinaryData関数の定義場所と実装を特定
- [ ] ダウンロードファイルのタイプ検証有無を確認
