---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：75-ZIPアップロード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **FreeASPUploadクラスの定義場所**：アップロード処理の詳細が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_uploadzip.asp` - ZIPアップロード画面メインファイル（行1-38）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.75の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-04: `asp/bs_templateList.asp` - テンプレート一覧画面（遷移元）
- E-05: `asp/bs_unzip.asp` - ZIP解凍画面（遷移先）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスはasp/bs_uploadzip.asp | E-01, E-02 | ○ |
| C-02 | secondAdmin.bTemplates権限が必要 | E-01（行4） | ○ |
| C-03 | customer.supportZipperがfalseならリダイレクト | E-01（行6） | ○ |
| C-04 | アップロード先はuserfiles配下 | E-01（行8） | ○ |
| C-05 | FreeASPUploadクラスを使用 | E-01（行10） | ○ |
| C-06 | checkCSRF_Upload()でトークン検証 | E-01（行17） | ○ |
| C-07 | ファイルタイプ検証（.zipのみ許可） | E-01（行22-26） | ○ |
| C-08 | 不正ファイルタイプ時はファイル削除 | E-01（行28-29） | ○ |
| C-09 | 成功時はbs_unzip.aspへリダイレクト | E-01（行30） | ○ |
| C-10 | ファイル未選択時にエラー | E-01（行34-35） | ○ |
| C-11 | アップロードエラー時のメッセージ表示 | E-01（行15-16） | ○ |
| C-12 | ENCTYPE="multipart/form-data"使用 | E-01（行36） | ○ |
| C-13 | アップロードボタンクリック時にdisabled設定 | E-01（行37） | ○ |
| C-14 | ボタン表示を「Please wait...」に変更 | E-01（行37） | ○ |
| C-15 | cls_zipperでZIPサポート確認 | E-01（行5） | ○ |
| C-16 | 関連機能No.28がテンプレートインポート | E-03 | ○ |
| C-17 | aspEasyZipコンポーネント使用の記載 | E-01（行37） | ○ |
| C-18 | FreeASPUploadクラスの定義場所 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **FreeASPUploadクラスの定義場所が不明**
  - 候補：begin.asp / 専用インクルードファイル
- checkCSRF_Upload関数の定義場所が不明
- アップロードサイズ制限の詳細設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ソースコードとの整合性が高い
- **1（中リスク）**: FreeASPUploadクラスの実装詳細が未確認
- **1（中リスク）**: アップロードサイズ制限の詳細が不明

## 6) レビュアーチェックリスト（最小）
- [ ] bs_uploadzip.aspの行4でsecondAdmin.bTemplates権限チェックを確認
- [ ] FreeASPUploadクラスの定義場所と実装を特定
- [ ] checkCSRF_Upload関数の実装を確認
- [ ] アップロードサイズ制限の設定を確認
- [ ] アップロード先フォルダの書き込み権限設定を確認
