---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：77-テーマ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **customer.themesコレクションの定義場所**：テーマ取得ロジックの詳細が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_themesList.asp` - テーマ一覧画面メインファイル（行1-11）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.77の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-04: `asp/bs_themeEdit.asp` - テーマ編集画面（遷移先）
- E-05: `asp/includes/theme.asp` - cls_themeクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスはasp/bs_themesList.asp | E-01, E-02 | ○ |
| C-02 | secondAdmin.bTheme権限が必要 | E-01（行4） | ○ |
| C-03 | cls_themeでコピー処理 | E-01（行5-6） | ○ |
| C-04 | コピー成功時bs_themeEdit.aspへリダイレクト | E-01（行7） | ○ |
| C-05 | customer.themesからテーマ一覧取得 | E-01（行9） | ○ |
| C-06 | テーマ0件時に「notheme」表示 | E-01（行9） | ○ |
| C-07 | テーマ名クリックでbs_themeEdit.aspへ遷移 | E-01（行10） | ○ |
| C-08 | コピーアイコンにconfirm()ダイアログ | E-01（行10） | ○ |
| C-09 | テーマコードテキストボックスにonclick="this.select()" | E-01（行10） | ○ |
| C-10 | テーマコード形式は[QS_THEME:xxx] | E-01（行10） | ○ |
| C-11 | テーマコード未設定時はテキストボックス非表示 | E-01（行10） | ○ |
| C-12 | iIDを表示 | E-01（行10） | ○ |
| C-13 | encrypt()でIDを暗号化 | E-01（行7, 10） | ○ |
| C-14 | sanitize()でテーマコードをエスケープ | E-01（行10） | ○ |
| C-15 | getIcon()でコピーアイコン生成 | E-01（行10） | ○ |
| C-16 | QS_secCodeURLでCSRFトークン付与 | E-01（行10） | ○ |
| C-17 | cls_theme.copy()メソッドの存在 | E-05 | ○ |
| C-18 | customer.themesコレクションの定義場所 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **customer.themesコレクションの定義場所が不明**
  - 候補：cls_customer / begin.asp
- getIcon関数の定義場所が不明
- テーマコピー時のデータベース操作詳細

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ソースコードとの整合性が高い
- **1（中リスク）**: customer.themesの実装詳細が未確認
- **0（低リスク）**: コピー処理はCSRFトークンで保護されている

## 6) レビュアーチェックリスト（最小）
- [ ] bs_themesList.aspの行4でsecondAdmin.bTheme権限チェックを確認
- [ ] customer.themesコレクションの定義場所を特定
- [ ] cls_theme.copy()メソッドの実装詳細を確認
- [ ] コピー処理時のデータベーストランザクション確認
- [ ] テーマコードのsanitize処理が適切か確認
