---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：78-テーマ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **cls_themeTypeList等のリストクラス定義場所**：選択肢生成ロジックの詳細が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_themeEdit.asp` - テーマ編集画面メインファイル（行1-49）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.78の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-04: `asp/bs_themesList.asp` - テーマ一覧画面（遷移元/遷移先）
- E-05: `asp/includes/theme.asp` - cls_themeクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスはasp/bs_themeEdit.asp | E-01, E-02 | ○ |
| C-02 | secondAdmin.bTheme権限が必要 | E-01（行4） | ○ |
| C-03 | postBackでフォーム再送信判定 | E-01（行7） | ○ |
| C-04 | btnaction="save"で保存処理 | E-01（行12） | ○ |
| C-05 | checkCSRF()でトークン検証 | E-01（行13, 19） | ○ |
| C-06 | theme.getRequestValues()でフォーム値取得 | E-01（行9, 14） | ○ |
| C-07 | theme.save()でデータベース保存 | E-01（行15） | ○ |
| C-08 | 保存成功時fb_saveOKメッセージ | E-01（行16） | ○ |
| C-09 | btnaction="delete"で削除処理 | E-01（行18） | ○ |
| C-10 | theme.remove()でテーマ削除 | E-01（行20） | ○ |
| C-11 | 削除後bs_themesList.aspへリダイレクト | E-01（行21） | ○ |
| C-12 | cls_themeTypeListでタイプ選択肢生成 | E-01（行24） | ○ |
| C-13 | cls_contactSearchでモデレーター選択肢生成 | E-01（行25-26） | ○ |
| C-14 | cls_theme_sublevelListでサブレベル選択肢生成 | E-01（行27-28） | ○ |
| C-15 | cls_siteSearchTypeListで検索タイプ選択肢生成 | E-01（行29-30） | ○ |
| C-16 | タイプ変更時にフォーム自動送信 | E-01（行30） | ○ |
| C-17 | HTML許可チェックでフォーム送信 | E-01（行31） | ○ |
| C-18 | bAllowHTMLでアップロード/埋め込み項目表示制御 | E-01（行31） | ○ |
| C-19 | bAllowCommentsで返信関連項目表示制御 | E-01（行34） | ○ |
| C-20 | JQColorPicker()でカラーピッカー生成 | E-01（行34） | ○ |
| C-21 | createFCKInstance()でリッチテキストエディタ生成 | E-01（行37） | ○ |
| C-22 | 削除ボタンにconfirm()ダイアログ | E-01（行37） | ○ |
| C-23 | cls_fullSearchでテーマ使用箇所検索 | E-01（行40-47） | ○ |
| C-24 | テーマ使用検索パターンは[QS_THEME:xxx] | E-01（行41） | ○ |
| C-25 | リストクラスの定義場所 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **cls_themeTypeList, cls_theme_sublevelList, cls_siteSearchTypeListの定義場所が不明**
  - 候補：begin.asp / 専用インクルードファイル
- QS_theme_cd, QS_theme_ts定数の定義場所が不明
- numberList関数の定義場所が不明

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ソースコードとの整合性が高い
- **0（低リスク）**: CSRF保護が実装されている
- **1（中リスク）**: リッチテキストエディタの入力検証（XSS対策）要確認
- **1（中リスク）**: テーマ削除時の関連データ（トピック、返信）の処理が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] bs_themeEdit.aspの行4でsecondAdmin.bTheme権限チェックを確認
- [ ] theme.save()のバリデーションロジックを確認
- [ ] theme.remove()時の関連データ削除処理を確認
- [ ] リッチテキスト（sTopicBodyNotification, sBodyNotification）のXSS対策を確認
- [ ] リストクラスの定義場所と選択肢の値を確認
