---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-コンテンツ付きアイテム編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - なし（全項目で根拠確認済み）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_editItem.asp` 行1-17
- E-02: `asp/bs_processPage.asp` 行1-50
- E-03: `asp/includes/page.asp` 行1-500
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 行9
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行16
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` 行100-120

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは asp/bs_editItem.asp である | E-04 | ○ |
| C-02 | bs_security.aspで認証チェック | E-01 行4 | ○ |
| C-03 | bs_process.aspをインクルード | E-01 行4 | ○ |
| C-04 | bs_processPage.aspで保存/削除処理 | E-01 行4 | ○ |
| C-05 | QS_secCodeHiddenでCSRFトークン | E-01 行4 | ○ |
| C-06 | iIdをHiddenで暗号化して渡す | E-01 行4 | ○ |
| C-07 | iParentIDをHiddenで暗号化して渡す | E-01 行4 | ○ |
| C-08 | bLossePaginaをHiddenで渡す | E-01 行4 | ○ |
| C-09 | btnactionがl("save")で設定 | E-01 行4 | ○ |
| C-10 | bs_common.aspで共通項目表示 | E-01 行4 | ○ |
| C-11 | bs_sortorder.aspでソート順設定 | E-01 行4 | ○ |
| C-12 | bs_onlineOrNot.aspで公開設定 | E-01 行4 | ○ |
| C-13 | 親ページ公開中かつ非ホームページの場合にホームページ設定表示 | E-01 行4-7 | ○ |
| C-14 | secondAdmin.bPageSetHomepageで権限チェック | E-01 行6 | ○ |
| C-15 | secondAdmin.bPageBodyでエディタ表示制御 | E-01 行13 | ○ |
| C-16 | createFCKInstanceでWYSIWYGエディタ生成 | E-01 行13 | ○ |
| C-17 | bs_url.aspでURL設定 | E-01 行16 | ○ |
| C-18 | bs_feed.aspでフィード設定 | E-01 行16 | ○ |
| C-19 | bs_catalog.aspでカタログ設定 | E-01 行16 | ○ |
| C-20 | bs_form.aspでフォーム設定 | E-01 行16 | ○ |
| C-21 | bs_application.aspでアプリケーション設定 | E-01 行16 | ○ |
| C-22 | bs_theme.aspでテーマ設定 | E-01 行16 | ○ |
| C-23 | bs_redirectTO.aspでリダイレクト設定 | E-01 行16 | ○ |
| C-24 | bs_template.aspでテンプレート設定 | E-01 行16 | ○ |
| C-25 | bs_metaTags.aspでメタタグ設定 | E-01 行16 | ○ |
| C-26 | secondAdmin.bPageUrlRSSでRSS URL表示制御 | E-01 行16 | ○ |
| C-27 | sRSSLinkをmaxlength="250"で入力 | E-01 行16 | ○ |
| C-28 | bs_deleteButton.aspで削除ボタン表示 | E-01 行16 | ○ |
| C-29 | 機能No.9「ページ作成・編集」に対応 | E-05 | ○ |
| C-30 | 多言語対応されている（l関数使用） | E-01 行4, 6, 16 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に対して根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成、インクルードファイル、フォーム項目が実装と一致
- 0: 低リスク - 権限チェックが実装されている
- 0: 低リスク - CSRFトークンが実装されている
- 0: 低リスク - 全項目で根拠が確認されている

## 6) レビュアーチェックリスト（最小）
- [ ] bs_editItem.aspの画面構成が設計書と一致しているか確認
- [ ] 権限チェック（secondAdmin各プロパティ）の動作を確認
- [ ] WYSIWYGエディタ（createFCKInstance）の動作を確認
- [ ] 保存処理（bs_processPage.asp）の動作を確認
- [ ] ホームページフラグの条件付き表示を確認
- [ ] 各インクルードファイルの役割を確認
