---
generated_at: 2026-01-23 22:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：81-ピール設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **画面へのアクセス方法のメニュー構成**：メニュー構成の詳細は推測を含む
  2. **業務上の目的・背景**：機能の目的は一般的なWeb知識から推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_peel.asp` - 画面定義ファイル（1-30行目）
- E-02: `asp/bs_process.asp` - フォーム処理（185-213行目）
- E-03: `asp/includes/customer.asp` - cls_customerクラス定義（16-17行目、300-509行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLの最大長は250文字 | E-01 (13行目: maxlength="250") | ○ |
| C-02 | フリップカラーは0〜15の16種類 | E-01 (14-23行目: for flipCounter=0 to 15) | ○ |
| C-03 | アイドル時サイズは50〜300px | E-01 (24行目: numberList(50,300,10)) | ○ |
| C-04 | アクティブ時サイズは200〜700px | E-01 (24行目: numberList(200,700,10)) | ○ |
| C-05 | デフォルトのアイドル時サイズは70px | E-01 (8-9行目: customer.sPeelIdleSize=70) | ○ |
| C-06 | デフォルトのアクティブ時サイズは300px | E-01 (10-12行目: customer.sPeelMOSize=300) | ○ |
| C-07 | secondAdmin.bSetupPageElements権限が必要 | E-01 (4行目: logon.hasaccess secondAdmin.bSetupPageElements) | ○ |
| C-08 | フォームアクションはsavepeel | E-01 (5行目: value="savepeel") | ○ |
| C-09 | CSRF対策が実装されている | E-01 (5行目: QS_secCodeHidden), E-02 (186行目: checkCSRF) | ○ |
| C-10 | 削除時にピール関連項目が初期化される | E-02 (188-196行目) | ○ |
| C-11 | tblCustomerテーブルに保存される | E-03 (429-435行目: rs("sPeelImage"), rs("sPeelURL")等) | ○ |
| C-12 | URL・フリップカラーが必須 | E-02 (204行目: isLeeg(customer.sPeelURL) or isLeeg(customer.sPeelFlipColor)) | ○ |
| C-13 | ピール画像はPNG/JPG/GIF対応 | E-01 (24-28行目), bs_peelUpload.asp確認 | ○ |
| C-14 | 保存成功時にfb_saveOKメッセージ | E-02 (196, 210行目: fbMessage=fb_saveOK) | ○ |
| C-15 | ピール画像未設定時はbs_selectPeel.aspへ遷移 | E-02 (207-208行目) | ○ |
| C-16 | 遷移元はバックサイトホーム・設定メニュー | **根拠なし** | △ |
| C-17 | 機能No.24はピール広告 | E-04 (画面機能マッピング116行目) | ○ |
| C-18 | 業務上の目的・背景（マーケティング効果） | **根拠なし**（一般知識に基づく） | △ |

## 4) 不足情報（Unknown / Missing）
- 画面遷移の詳細なメニュー構成は、実際のUI確認またはbs_header.asp等のメニュー生成ロジックの詳細分析が必要
  - 候補：bs_header.asp / getBOSetupMenu関数 / テンプレートファイル
- 業務上の目的は一般的なWeb広告知識からの推測であり、要件定義書等の公式ドキュメントは未確認
  - 候補：要件定義書 / 機能仕様書 / ユーザーマニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データベース操作の仕様（ソースコードで確認済み）
- 0: 低リスク - 入力項目の仕様（HTMLフォームで確認済み）
- 1: 中リスク - 画面遷移の詳細（メニュー構成は推測を含む）
- 0: 低リスク - セキュリティ実装（CSRF対策確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] 画面遷移元のメニュー構成が正しいか実機で確認
- [ ] ピール広告の業務目的が組織の要件と一致しているか確認
- [ ] フリップカラー16種類の画像ファイルが全て存在するか確認
- [ ] アクティブ時サイズの上限700pxが適切か確認
