---
generated_at: 2026-01-23 22:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：82-ピール選択

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **FreeASPUploadクラスの詳細**：外部ライブラリの詳細仕様は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_selectPeel.asp` - 画面定義ファイル（1-6行目）
- E-02: `asp/bs_peelUpload.asp` - アップロード処理（1-43行目）
- E-03: `asp/includes/customer.asp` - cls_customerクラス定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォームアクションはbs_PeelUpload.asp | E-01 (4行目: ACTION="bs_PeelUpload.asp") | ○ |
| C-02 | multipart/form-dataエンコーディング使用 | E-01 (4行目: ENCTYPE="multipart/form-data") | ○ |
| C-03 | secondAdmin.bSetupPageElements権限が必要 | E-01 (4行目: logon.hasaccess secondAdmin.bSetupPageElements) | ○ |
| C-04 | ファイル入力のname属性は"peel" | E-01 (5行目: NAME="peel") | ○ |
| C-05 | 対応ファイル形式はPNG/JPG/GIF | E-02 (14-18行目: case "png","jpg","gif") | ○ |
| C-06 | 最大ファイルサイズは2MB | E-02 (22行目: lcase(Upload.UploadedFiles(fileKey).Length)>2000000) | ○ |
| C-07 | エラー時はstrMessageパラメータで自画面にリダイレクト | E-02 (42行目) | ○ |
| C-08 | 成功時はbs_peel.aspにリダイレクト | E-02 (40行目) | ○ |
| C-09 | CSRF対策が実装されている | E-01 (5行目: QS_secCodeHidden), E-02 (9行目: checkCSRF_Upload) | ○ |
| C-10 | アップロードファイルはuserfilesディレクトリに保存 | E-02 (5行目: Application("QS_CMS_userfiles")) | ○ |
| C-11 | ファイル名はpeel_+ランダム文字列+拡張子 | E-02 (30行目: "peel_" & generatePassword & ".") | ○ |
| C-12 | err_fileType, err_fileSize, err_newFileエラーコード | E-02 (17,23,36行目) | ○ |
| C-13 | 不正なファイルは削除される | E-02 (26行目: Upload.UploadedFiles(fileKey).delete()) | ○ |
| C-14 | FreeASPUploadクラスが使用される | E-02 (7行目: Set Upload = New FreeASPUpload) | ○ |

## 4) 不足情報（Unknown / Missing）
- FreeASPUploadクラスの詳細実装は外部ライブラリのため、本プロジェクト内では確認できない
  - 候補：FreeASPUpload.asp / 外部ドキュメント / サードパーティライブラリ仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイル形式・サイズ検証（ソースコードで確認済み）
- 0: 低リスク - CSRF対策（checkCSRF_Upload確認済み）
- 1: 中リスク - FreeASPUploadクラスの挙動（外部ライブラリ）
- 0: 低リスク - リダイレクト先（ソースコードで確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] FreeASPUploadクラスのセキュリティ（パストラバーサル等）が適切か確認
- [ ] 2MBの上限サイズが運用要件に適合しているか確認
- [ ] アップロードディレクトリのパーミッションが適切か確認
- [ ] generatePassword関数の出力がファイル名として安全か確認
