---
generated_at: 2026-01-23 22:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：84-クッキー警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **GDPR準拠性**：法的要件との整合性は別途確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_cookiewarning.asp` - 画面定義ファイル（1-88行目）
- E-02: `asp/includes/customer.asp` - cls_customerクラス定義（17行目、1562-1610行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報（119行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bCookieWarning権限が必要 | E-01 (4行目: logon.hasaccess secondAdmin.bCookieWarning) | ○ |
| C-02 | 表示位置はtop/bottomから選択 | E-01 (84行目: select name="sCWLocation", value="top", "bottom") | ○ |
| C-03 | 表示回数は0〜20 | E-01 (84行目: numberList(0,20,1,...)) | ○ |
| C-04 | 0の場合は常時表示 | E-01 (84行目のコメント: "0: the warning will keep on showing") | ○ |
| C-05 | 言語コード2はオランダ語 | E-01 (8行目: case 2 'Nederlands) | ○ |
| C-06 | デフォルト背景色は#000000 | E-01 (27行目: customer.sCWBackgroundColor="#000000") | ○ |
| C-07 | デフォルト文字色は#FFFFFF | E-01 (29行目: customer.sCWTextColor="#FFFFFF") | ○ |
| C-08 | デフォルトボタンクラスはart-button | E-01 (28行目: customer.sCWButtonClass="art-button") | ○ |
| C-09 | 最小設定ではsCWText=""（開示文なし） | E-01 (42行目, 54行目) | ○ |
| C-10 | postback=1でフォーム保存を識別 | E-01 (68行目: if postback then) | ○ |
| C-11 | 成功時はfb_saveOKでリダイレクト | E-01 (34, 65, 82行目: fbMessage=fb_saveOK) | ○ |
| C-12 | プレビューはQSbcwp=1パラメータで強制表示 | E-01 (87行目: QSbcwp=1), E-02 (227行目) | ○ |
| C-13 | WYSIWYGエディタでsCWTextを編集 | E-01 (84行目: dumpFCKInstance) | ○ |
| C-14 | カラーピッカーはJQColorPicker関数 | E-01 (各色設定: JQColorPicker()) | ○ |
| C-15 | bCWUseAsNormalPP=trueで承認ブロック非表示 | E-01 (87行目), E-02 (1603-1604行目) | ○ |
| C-16 | sCWAcceptの最大長は250文字 | E-01 (87行目: maxlength=250) | ○ |
| C-17 | sCWContinueの最大長は50文字 | E-01 (87行目: maxlength=50) | ○ |
| C-18 | sCWErrorの最大長は250文字 | E-01 (87行目: maxlength=250) | ○ |
| C-19 | sCWButtonClassの最大長は50文字 | E-01 (87行目: maxlength=50) | ○ |
| C-20 | CookieDirective15.jsを使用 | E-02 (1575行目) | ○ |
| C-21 | 機能No.34はCookie警告設定 | E-03 (119行目) | ○ |
| C-22 | GDPR規制に対応 | **根拠なし**（法的要件との整合性は別途確認要） | △ |

## 4) 不足情報（Unknown / Missing）
- GDPR規制との法的整合性は、法務専門家による確認が必要
  - 候補：法務レビュー / GDPR要件仕様書 / コンプライアンスチェックリスト
- CookieDirective15.jsの詳細実装は本ファイルでは確認不可
  - 候補：js/CookieDirective15.js の内容確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定項目の仕様（ソースコードで確認済み）
- 0: 低リスク - データベース保存処理（customer.save確認済み）
- 2: 高リスク - GDPR準拠性（法的要件は別途確認が必要）
- 1: 中リスク - CookieDirective15.jsの挙動（外部JSファイル）

## 6) レビュアーチェックリスト（最小）
- [ ] GDPR要件との整合性を法務担当者と確認
- [ ] CookieDirective15.jsが最新のCookie同意規制に対応しているか確認
- [ ] デフォルトのCookieポリシーリンク先（cookiespolicy.html）の内容が適切か確認
- [ ] 多言語対応（英語・オランダ語以外）が必要か確認
- [ ] bCWUseAsNormalPPオプション使用時の法的リスクを確認
