---
generated_at: 2026-01-23 22:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：85-モバイル設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **モバイル判定ロジックの詳細**：フロントエンド側での判定処理は別ファイルで実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_mobileSetup.asp` - 画面定義ファイル（1-17行目）
- E-02: `asp/includes/customer.asp` - cls_customerクラス定義（16行目、190-192行目、437-439行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報（120行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sMOBUrlのデフォルト値は"http://" | E-01 (4-6行目: if isleeg(customer.sMOBUrl) then customer.sMOBUrl="http://") | ○ |
| C-02 | postback=1でフォーム送信を識別 | E-01 (7行目: request.form("postback")="1") | ○ |
| C-03 | セッション変数"checkMobileBrowser"をクリア | E-01 (8行目: session("checkMobileBrowser")="") | ○ |
| C-04 | sMOBBrowsersはtrim処理される | E-01 (9行目: trim(request.form("sMOBBrowsers"))) | ○ |
| C-05 | sMOBUrlはtrim処理される | E-01 (10行目: trim(request.form("sMOBUrl"))) | ○ |
| C-06 | iDefaultMobileTemplateはdecrypt処理される | E-01 (11行目: convertGetal(decrypt(request.form("iDefaultMobileTemplate")))) | ○ |
| C-07 | 保存ボタン押下でcustomer.save()を実行 | E-01 (14行目) | ○ |
| C-08 | 成功時はfb_saveOKでリダイレクト | E-01 (15行目: fbMessage=fb_saveOK) | ○ |
| C-09 | テキストエリアの幅は400px | E-01 (16行目: style="width:400px") | ○ |
| C-10 | sMOBUrlの最大長は255文字 | E-01 (16行目: maxlength=255) | ○ |
| C-11 | showSelectedtemplateでテンプレート一覧を取得 | E-01 (16行目), E-02 (1018-1034行目) | ○ |
| C-12 | application("QSmostrecentUA")で最近のUAを表示 | E-01 (16行目) | ○ |
| C-13 | 機能No.31はモバイル設定 | E-03 (120行目) | ○ |
| C-14 | テンプレートとリダイレクトURLは排他利用 | **根拠なし**（ロジック上の推測） | △ |

## 4) 不足情報（Unknown / Missing）
- テンプレートとリダイレクトURLの排他利用ロジックはフロントエンド側で実装されている可能性
  - 候補：begin.asp / default.asp / フロントエンド描画処理
- モバイル判定処理（HTTP_USER_AGENTとsMOBBrowsersのマッチング）の詳細実装
  - 候補：begin.asp / モバイル判定関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定項目の仕様（ソースコードで確認済み）
- 0: 低リスク - データベース保存処理（customer.save確認済み）
- 1: 中リスク - モバイル判定ロジックの詳細（別ファイルで実装）
- 0: 低リスク - セッションキャッシュのクリア処理（確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] モバイル判定処理（HTTP_USER_AGENTマッチング）の実装箇所を確認
- [ ] テンプレートとリダイレクトURLの優先順位を確認
- [ ] 最近のHTTP_USER_AGENT（application("QSmostrecentUA")）の収集・更新処理を確認
- [ ] sMOBBrowsersの改行区切りキーワードの処理方法を確認
