---
generated_at: 2026-01-23 22:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：86-変数設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **変数置換処理の詳細**：treatconstants関数等の実装は別ファイル
  2. **各変数の取得元**：一部の変数は動的生成のため詳細実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_variables.asp` - 画面定義ファイル（1-14行目）
- E-02: `asp/includes/customer.asp` - cls_customerクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報（121行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 純粋なHTMLページとして実装 | E-01 (DOCTYPE宣言、ASPコードなし) | ○ |
| C-02 | onclick="javascript:this.select()"で全選択 | E-01 (各input/textareaのonclick属性) | ○ |
| C-03 | [SITENAME]はサイト名を表示 | E-01 (2行目の説明テキスト) | ○ |
| C-04 | [QS_BOOTSTRAPMENU_3]はBootstrap 3形式 | E-01 (3行目の説明テキスト) | ○ |
| C-05 | [QS_ARTISTEER_FULLMENU_V4]はArtisteer 4専用 | E-01 (4行目の説明テキスト) | ○ |
| C-06 | 検索フォームはtextareaで複数行表示 | E-01 (6-11行目のtextarea) | ○ |
| C-07 | [PAGERENDERTIME]はHTMLコメント形式 | E-01 (13行目: <!--[PAGERENDERTIME]-->) | ○ |
| C-08 | 機能No.5はサイト基本設定 | E-03 (121行目) | ○ |
| C-09 | 認証不要の静的ページ | E-01 (ASP認証コードなし) | ○ |
| C-10 | 背景色は白（#FFF） | E-01 (body style="background-color:#FFF") | ○ |
| C-11 | 変数はtreatconstants関数で置換される | **根拠なし**（別ファイルで実装） | △ |
| C-12 | [SITENAME]はcustomer.siteNameから取得 | **根拠なし**（置換処理の実装未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- 変数置換処理（treatconstants関数等）の詳細実装
  - 候補：begin.asp / default.asp / テンプレート処理関連ファイル
- 各変数の実際の取得元と置換ロジック
  - 候補：テンプレート処理エンジン / メニュー生成関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面表示内容（HTMLで確認済み）
- 0: 低リスク - onclick動作（JavaScript確認済み）
- 1: 中リスク - 変数置換処理の詳細（別ファイルで実装）
- 1: 中リスク - 変数一覧の網羅性（他にも変数がある可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] 変数置換処理（treatconstants関数等）の実装を確認
- [ ] 一覧に記載されていない変数がないか確認
- [ ] 各変数の実際の出力値を実機で確認
- [ ] Artisteer関連変数がArtisteer以外のテンプレートで使用された場合の挙動を確認
