---
generated_at: 2026-01-23 22:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：87-定数一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **cls_formatListクラスの詳細**：タイプ表示名の取得処理は別ファイルで実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_constantList.asp` - 画面定義ファイル（1-14行目）
- E-02: `asp/includes/constant.asp` - cls_constantクラス定義（1-112行目）
- E-03: `asp/includes/customer.asp` - constants関数（1103-1118行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bHomeConstants権限が必要 | E-01 (4行目: logon.hasaccess secondAdmin.bHomeConstants) | ○ |
| C-02 | VBScript定数は一覧から除外 | E-01 (10行目: if QS_VBScript<>cconstants(keyconstants).iType then) | ○ |
| C-03 | 定数タグは[大文字]形式 | E-01 (10行目: [<%=sanitize(cconstants(keyconstants).sConstant)%>]) | ○ |
| C-04 | 定数はcustomer.constantsで取得 | E-01 (6行目: set cconstants=customer.constants) | ○ |
| C-05 | cls_formatListでタイプ表示名取得 | E-01 (7-8行目, 10行目: formatList.showSelected) | ○ |
| C-06 | statusStringでオンライン状態表示 | E-01 (10行目: cconstants(keyconstants).statusString), E-02 (90-96行目) | ○ |
| C-07 | オフライン定数は色付き表示 | E-02 (94行目: MYQS_offlineLinkColor) | ○ |
| C-08 | 編集画面への遷移はiContentID暗号化 | E-01 (10行目: encrypt(keyconstants)) | ○ |
| C-09 | VBScript権限はsecondAdmin.bHomeVBScript | E-01 (5行目) | ○ |
| C-10 | customer.bApplicationがtrueの場合のみVBScriptリンク表示 | E-01 (5行目: if customer.bApplication and secondAdmin.bHomeVBScript) | ○ |
| C-11 | 定数はtblConstantテーブルに保存 | E-03 (1107行目) | ○ |
| C-12 | cls_constantクラスはiId,sConstant,sValue,iType等を持つ | E-02 (3行目) | ○ |
| C-13 | 定数コレクションはDictionaryで管理 | E-03 (1104行目: server.CreateObject("scripting.dictionary")) | ○ |
| C-14 | onclick="javascript:this.select()"で全選択 | E-01 (10行目) | ○ |
| C-15 | 機能No.94は定数一覧、No.95は定数作成・編集 | E-04 (122-125行目) | ○ |
| C-16 | cls_formatListクラスの詳細実装 | **根拠なし**（別ファイルで定義） | △ |

## 4) 不足情報（Unknown / Missing）
- cls_formatListクラスの詳細実装（タイプコードと表示名の対応）
  - 候補：includes/formatList.asp または類似ファイル
- QS_VBScript, QS_textonly, QS_htmlの定数定義箇所
  - 候補：constants.asp / begin.asp / 共通定義ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 一覧表示処理（ソースコードで確認済み）
- 0: 低リスク - 権限チェック（確認済み）
- 1: 中リスク - タイプ表示名の取得処理（cls_formatListの実装未確認）
- 0: 低リスク - 暗号化処理（encrypt関数使用確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] cls_formatListクラスの実装を確認
- [ ] QS_VBScript, QS_textonly, QS_htmlの定数値を確認
- [ ] 定数タグの大文字変換処理（sConstant保存時）を確認
- [ ] bOnlineプロパティの判定ロジック（dOnlineFrom, dOnlineUntill）を確認
