---
generated_at: 2026-01-23 22:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：88-定数編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **cls_fullSearchクラスの詳細**：使用箇所検索の実装は別ファイル

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_constantEdit.asp` - 画面定義ファイル（1-46行目）
- E-02: `asp/includes/constant.asp` - cls_constantクラス定義（1-112行目）
- E-03: `asp/includes/customer.asp` - cacheConstants関数（1119-1142行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bHomeConstants権限が必要 | E-01 (4行目: logon.hasaccess secondAdmin.bHomeConstants) | ○ |
| C-02 | 定数名は大文字に自動変換 | E-02 (64行目: rs("sConstant") = ucase(left(sConstant,50))) | ○ |
| C-03 | 定数名の最大長は50文字 | E-02 (64行目: left(sConstant,50)) | ○ |
| C-04 | []は自動除去される | E-02 (31-32行目: Replace(sConstant, "[", ""), Replace(sConstant, "]", "")) | ○ |
| C-05 | sConstant・sValueが必須 | E-02 (33-40行目: isLeeg(sConstant), isLeeg(sValue)) | ○ |
| C-06 | 重複チェックを実行 | E-02 (42-46行目: select count(iId)...) | ○ |
| C-07 | 保存時にcacheConstants呼び出し | E-02 (76行目: customer.cacheConstants()) | ○ |
| C-08 | 削除時もcacheConstants呼び出し | E-02 (102行目) | ○ |
| C-09 | タイプ変更でonchange送信 | E-01 (30行目: onchange="javascript:document.mainform.btnaction.value='';document.mainform.submit();") | ○ |
| C-10 | CSRF検証実行 | E-01 (11, 17行目: checkCSRF()) | ○ |
| C-11 | VBScriptの場合はテストボタン表示 | E-01 (32行目: if QS_VBScript=constant.iType then) | ○ |
| C-12 | VBScript削除後はbs_scriptlist.aspにリダイレクト | E-01 (19-20行目) | ○ |
| C-13 | その他削除後はbs_constantlist.aspにリダイレクト | E-01 (21-22行目) | ○ |
| C-14 | パラメータの最大長は200文字 | E-01 (32行目: maxlength=200) | ○ |
| C-15 | 使用箇所検索はcls_fullSearch使用 | E-01 (35-36行目) | ○ |
| C-16 | 検索パターンは正規表現 | E-01 (36行目: fsearch.pattern=...) | ○ |
| C-17 | テストフォームは新しいウィンドウで開く | E-01 (45行目: target="<%=generatePassword()%>") | ○ |
| C-18 | 機能No.95は定数作成・編集 | E-04 (124行目) | ○ |
| C-19 | HTMLタイプの場合はFCKEditorを使用 | E-01 (31行目: createFCKInstance) | ○ |
| C-20 | cls_fullSearchクラスの詳細実装 | **根拠なし**（別ファイルで定義） | △ |

## 4) 不足情報（Unknown / Missing）
- cls_fullSearchクラスの詳細実装（正規表現検索処理）
  - 候補：includes/fullSearch.asp または類似ファイル
- QS_VBScript, QS_textonly, QS_htmlの定数値
  - 候補：constants.asp / begin.asp / 共通定義ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 保存処理（ソースコードで確認済み）
- 0: 低リスク - バリデーション処理（確認済み）
- 1: 中リスク - 使用箇所検索の精度（cls_fullSearchの実装未確認）
- 2: 高リスク - VBScript実行のセキュリティ（任意コード実行のリスク）

## 6) レビュアーチェックリスト（最小）
- [ ] cls_fullSearchクラスの実装を確認
- [ ] VBScript定数のセキュリティリスクを評価（任意コード実行）
- [ ] cacheConstants関数のキャッシュ更新タイミングを確認
- [ ] 重複チェックのSQL文がインジェクションに対して安全か確認
