---
generated_at: 2026-01-23 22:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：89-定数テスト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **executeConstant関数の詳細**：関数の実装は別ファイル
  2. **QS_VBScriptIdentifierの値**：区切り文字の定義は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_constantTest.asp` - 画面定義ファイル（1-10行目）
- E-02: `asp/bs_constantEdit.asp` - 定数編集画面（テストフォーム送信元）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bHomeVBScript権限が必要 | E-01 (4行目: logon.hasaccess secondAdmin.bHomeVBScript) | ○ |
| C-02 | 背景色は白（#FFF） | E-01 (4行目: body style="background-color:#FFF") | ○ |
| C-03 | パラメータありの場合フォーム表示 | E-01 (4行目: if Request.Form("sParameters")<>"" then) | ○ |
| C-04 | CSRF検証実行 | E-01 (5行目: checkCSRF()) | ○ |
| C-05 | executeConstant関数で実行 | E-01 (7行目) | ○ |
| C-06 | 第2引数trueでテストモード | E-01 (7行目: executeConstant(..., true, ...)) | ○ |
| C-07 | パラメータ値はダブルクォートで囲む | E-01 (4行目: "between double quotes!") | ○ |
| C-08 | 簡易ヘッダー（commonheader.asp）使用 | E-01 (4行目: include file="includes/commonheader.asp") | ○ |
| C-09 | cleanUPASP呼び出し | E-01 (9行目) | ○ |
| C-10 | cPopup.dumpJS呼び出し | E-01 (8行目) | ○ |
| C-11 | message.showAlert呼び出し | E-01 (8行目) | ○ |
| C-12 | 機能No.95は定数作成・編集 | E-03 (125行目) | ○ |
| C-13 | executeConstant関数の詳細実装 | **根拠なし**（別ファイルで定義） | △ |
| C-14 | QS_VBScriptIdentifierの区切り文字 | **根拠なし**（定数定義未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- executeConstant関数の詳細実装（VBScript動的実行処理）
  - 候補：includes/functions.asp / begin.asp / 共通関数ファイル
- QS_VBScriptIdentifierの定義値
  - 候補：constants.asp / begin.asp / 共通定義ファイル
- CustomFunction変数への代入による出力の仕組み
  - 候補：executeConstant関数内の実装

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - VBScript動的実行（任意コード実行のセキュリティリスク）
- 1: 中リスク - executeConstant関数の実装（詳細未確認）
- 0: 低リスク - CSRF検証（確認済み）
- 0: 低リスク - 権限チェック（確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] executeConstant関数の実装を確認
- [ ] VBScript動的実行のセキュリティリスクを評価
- [ ] QS_VBScriptIdentifierの値と用途を確認
- [ ] テストモードと本番モードの違いを確認
- [ ] 実行エラー時の詳細なエラーハンドリングを確認
