---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-リストページ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全項目で根拠確認済み）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_listPage.asp` 行1-82
- E-02: `asp/includes/page.asp` 行1-500
- E-03: `asp/includes/customer.asp` 行1-700
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 行10
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行17
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` 行130-150

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは asp/bs_listPage.asp である | E-04 | ○ |
| C-02 | bs_security.aspで認証チェック | E-01 行2 | ○ |
| C-03 | bs_process.aspをインクルード | E-01 行3 | ○ |
| C-04 | iDeleteLIIDパラメータで削除対象指定 | E-01 行8 | ○ |
| C-05 | checkCSRF()で削除前トークン検証 | E-01 行9 | ○ |
| C-06 | cls_pageでpickしてlistitem取得 | E-01 行10-11 | ○ |
| C-07 | bDeleted=true、bOnline=false設定 | E-01 行13-14 | ○ |
| C-08 | save()でデータベース更新 | E-01 行15 | ○ |
| C-09 | fb_topicremoved メッセージでリダイレクト | E-01 行16 | ○ |
| C-10 | iCopyIidパラメータでコピー対象指定 | E-01 行22 | ○ |
| C-11 | コピー時にiId=null設定 | E-01 行28 | ○ |
| C-12 | コピー時にsCode=""設定 | E-01 行29 | ○ |
| C-13 | コピー時にsUserFriendlyURL=""設定 | E-01 行30 | ○ |
| C-14 | コピー時にタイトルに" (copy)"追加 | E-01 行31 | ○ |
| C-15 | page.listitems(false)でアイテム一覧取得 | E-01 行42 | ○ |
| C-16 | For Eachでアイテムループ表示 | E-01 行45 | ○ |
| C-17 | getClickLink(true)でリンク生成 | E-01 行46 | ○ |
| C-18 | bs_editListItem.asp?iId=へ編集リンク | E-01 行47 | ○ |
| C-19 | UserFriendlyURL有無でプレビューURL分岐 | E-01 行49-53 | ○ |
| C-20 | customer.bListItemPicで画像機能判定 | E-01 行56 | ○ |
| C-21 | sItemPicture有無で画像設定/アップロード分岐 | E-01 行57-66 | ○ |
| C-22 | colorboxでモーダル表示 | E-01 行59-65 | ○ |
| C-23 | コピー時にconfirm確認 | E-01 行69-71 | ○ |
| C-24 | 削除時にconfirm確認（deletecomplete） | E-01 行73-75 | ○ |
| C-25 | makenormalpageで通常ページ変換 | E-01 行79 | ○ |
| C-26 | bs_editList.aspへのリンク | E-01 行43 | ○ |
| C-27 | bs_editListItem.aspへ新規追加リンク | E-01 行44 | ○ |
| C-28 | 多言語対応されている（l関数使用） | E-01 行42, 44, 47等 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に対して根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成、削除・コピー処理が実装と一致
- 0: 低リスク - CSRFトークン検証が実装されている
- 0: 低リスク - 確認ダイアログが実装されている
- 0: 低リスク - 全項目で根拠が確認されている

## 6) レビュアーチェックリスト（最小）
- [ ] bs_listPage.aspの画面構成が設計書と一致しているか確認
- [ ] 削除処理（iDeleteLIID）の動作を確認
- [ ] コピー処理（iCopyIid）の動作を確認
- [ ] page.listitems()のアイテム取得を確認
- [ ] 画像機能（bListItemPic）の条件分岐を確認
- [ ] colorboxモーダルの動作を確認
- [ ] 通常ページ変換の動作を確認
